/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.graphics.colortable.SimpleColorTable;
import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcNode;
import java.awt.Color;
import java.net.URL;
import org.apache.commons.lang3.StringEscapeUtils;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.VariableDS;

public class NcHdfPalette
extends NcNode {
    private VariableDS varDS_;
    private NcDataset dataset_;
    private SimpleColorTable ctable_;

    public NcHdfPalette(NcDataset d, String varname) {
        this(d, d.findVariable(varname));
    }

    public NcHdfPalette(NcDataset d, VariableDS v) {
        this.setParent(d);
        this.dataset_ = d;
        this.varDS_ = v;
        this.getColorTable();
    }

    public synchronized SimpleColorTable getColorTable() {
        String palModelS;
        String palTypeS;
        if (this.ctable_ != null) {
            return this.ctable_;
        }
        Attribute palVersionA = this.varDS_.findAttribute("PAL_VERSION");
        Attribute palTypeA = this.varDS_.findAttribute("PAL_TYPE");
        String string = palTypeS = palTypeA == null ? "STANDARD" : palTypeA.getStringValue();
        if (!palTypeS.equals("STANDARD") && !palTypeS.equals("STANDARD8")) {
            throw new NcException("I cannot parse range palettes.");
        }
        Attribute palRangeA = this.varDS_.findAttribute("RANGE_INDEX");
        Attribute palModelA = this.varDS_.findAttribute("PAL_COLORMODEL");
        String string2 = palModelS = palModelA == null ? "RGB" : palTypeA.getStringValue();
        if (!palModelS.equals("RGB")) {
            throw new NcException("I only understand RGB HDF palettes.");
        }
        if (this.varDS_.getRank() != 2) {
            throw new NcException("HDF palette must have rank 2.");
        }
        this.ctable_ = new SimpleColorTable();
        this.ctable_.setName(this.dataset_.getName() + "+" + this.getName());
        this.ctable_.setType("HDF");
        try {
            this.ctable_.setURL(new URL(this.dataset_.getURL().toString() + "#" + this.getName()));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Could not create HDF palette name.");
        }
        int[] shape = this.varDS_.getShape();
        this.ctable_.setColorCount(shape[0]);
        try {
            Array a = this.varDS_.read();
            Index idx = a.getIndex();
            for (int i = 0; i < shape[0]; ++i) {
                int r = a.getInt(idx.set(i, 0)) & 0xFF;
                int g = a.getInt(idx.set(i, 1)) & 0xFF;
                int b = a.getInt(idx.set(i, 2)) & 0xFF;
                this.ctable_.setColorAt(i, new Color(r, g, b));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Could not read HDF palette data");
        }
        return this.ctable_;
    }

    public NcDataset getDataset() {
        return this.dataset_;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.varDS_;
    }

    @Override
    public String getName() {
        return this.varDS_.getFullName();
    }

    @Override
    public TreeTableNode[] getChildren() {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getNcType() {
        return "HDF Palette";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer("");
        sb.append("<html><body>");
        sb.append("<h3>Palette \"").append(this.getName()).append("\"</h3>\n");
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append(StringEscapeUtils.escapeHtml4(this.varDS_.toString()));
        sb.append("\n");
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }
}

