/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Group;

public class NcGroup
extends NcNode {
    private static Logger logger_ = LoggerFactory.getLogger(NcGroup.class);
    private String name_ = "GROUP";

    public NcGroup(NcDataset d, Group g) throws IOException {
        this.setParent(d);
        this.dataset_ = d;
        this.group_ = g;
        NcGroup.initChildrenFromGroup(this.dataset_, this, this.group_, this.showOnlyPlottables_);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.group_.getShortName();
    }

    @Override
    public String getLongName() {
        return this.group_.getFullName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>Group \"").append(this.getName()).append("\"</h2>\n");
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append(StringEscapeUtils.escapeHtml4(this.group_.toString()));
        sb.append("\n");
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }
}

