/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.util.FileUtilities;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;

public class NcGribUtilities {
    private static Logger logger_ = LoggerFactory.getLogger(NcGribUtilities.class);

    private NcGribUtilities() {
    }

    public static void initGribHandling() {
        NcGribUtilities.setGrib1Strict(true);
        File tabdir = FileUtilities.getApplicationSupportDir("GISS", ".gissjava", "gribtab");
        if (!tabdir.exists()) {
            return;
        }
        if (!tabdir.isDirectory()) {
            logger_.warn("Library gribtab path blocked");
            return;
        }
        try {
            File f = new File(tabdir, "grib1lookuptable.lst");
            if (f.exists()) {
                NcGribUtilities.openGrib1LookupList(f);
            }
        }
        catch (Exception exc) {
            logger_.warn("Error creating GRIB-1 lookup list File object {}", exc);
        }
        try {
            File file = new File(tabdir, "grib2lookuptable.lst");
            if (file.exists()) {
                String string = file.getAbsolutePath();
            }
        }
        catch (Exception exc) {
            logger_.warn("Error creating GRIB-2 lookup list File object {}", exc);
        }
    }

    public static void setGrib1Strict(boolean strict) {
        Grib1ParamTables.setStrict(strict);
    }

    public static boolean openGrib1LookupList(File f) {
        if (f == null) {
            throw new IllegalArgumentException("Null File passed");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("No file matching File object");
        }
        Object fpath = null;
        try {
            Grib1ParamTables.addParameterTableLookup(f.getAbsolutePath());
            return true;
        }
        catch (Exception exc) {
            logger_.warn("Exception accessing GRIB-1 lookup list {}", exc);
            return false;
        }
    }

    public static boolean openGrib1Table(File f, int center, int subcenter, int version) {
        if (f == null) {
            throw new IllegalArgumentException("Null File passed");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("No file matching File object");
        }
        try {
            Grib1ParamTables.addParameterTable(center, subcenter, version, f.getAbsolutePath());
            return true;
        }
        catch (Exception exc) {
            logger_.warn("Exception accessing GRIB-1 lookup table {}", exc);
            return false;
        }
    }
}

