/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public class NcFilenameFilter
implements FilenameFilter {
    private static final String[] NC_EXTENSIONS = new String[]{"nc", "ncml", "nc3", "nc4"};
    private static final String[] HDF_EXTENSIONS = new String[]{"hdf", "hd4", "hdf4", "h5", "hd5", "hdf5", "he4", "he5", "eos", "hdfeos"};
    private static final String[] GRIB_EXTENSIONS = new String[]{"grb", "grb1", "grb2", "grib", "grib2", "gr2"};
    private static final String[] COMPRESSION_EXTENSIONS = new String[]{"bz2", "gz", "gzip", "z"};
    private static String[] NC_PLUS_EXTENSIONS;
    private static String[] HDF_PLUS_EXTENSIONS;
    private static String[] GRIB_PLUS_EXTENSIONS;
    private static String[] ALL_PLUS_EXTENSIONS;
    private FilterType type_;

    public NcFilenameFilter() {
        this(FilterType.NETCDF);
    }

    public NcFilenameFilter(FilterType type) {
        this.type_ = type;
    }

    public static String[] getExtensions() {
        return NcFilenameFilter.getExtensions(FilterType.ALL);
    }

    public static String[] getExtensions(FilterType type) {
        switch (type) {
            case NETCDF: {
                return NC_PLUS_EXTENSIONS;
            }
            case HDF: {
                return HDF_PLUS_EXTENSIONS;
            }
            case GRIB: {
                return GRIB_PLUS_EXTENSIONS;
            }
        }
        return ALL_PLUS_EXTENSIONS;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (NcFilenameFilter.accept(this.type_, name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean accept(File f) {
        if (f == null) {
            throw new IllegalArgumentException("File is null.");
        }
        return NcFilenameFilter.accept(FilterType.ALL, f.getName());
    }

    public static boolean accept(FilterType type, File f) {
        if (f == null) {
            throw new IllegalArgumentException("File is null.");
        }
        return NcFilenameFilter.accept(type, f.getName());
    }

    public static boolean accept(String fname) {
        return NcFilenameFilter.accept(FilterType.ALL, fname);
    }

    public static boolean accept(FilterType type, String fname) {
        if (fname == null) {
            throw new IllegalArgumentException("File name is null.");
        }
        String lcname = fname.toLowerCase();
        switch (type) {
            case NETCDF: {
                for (String extension : NC_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            case HDF: {
                for (String extension : HDF_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            case GRIB: {
                for (String extension : GRIB_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
                break;
            }
            default: {
                for (String extension : ALL_PLUS_EXTENSIONS) {
                    if (!lcname.endsWith("." + extension)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        ArrayList<String> ncExtensions = new ArrayList<String>(25);
        ArrayList<String> hdfExtensions = new ArrayList<String>(50);
        ArrayList<String> gribExtensions = new ArrayList<String>(25);
        ArrayList<String> allExtensions = new ArrayList<String>(100);
        for (String s1 : NC_EXTENSIONS) {
            ncExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                ncExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        for (String s1 : HDF_EXTENSIONS) {
            hdfExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                hdfExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        for (String s1 : GRIB_EXTENSIONS) {
            gribExtensions.add(s1);
            allExtensions.add(s1);
            for (String s2 : COMPRESSION_EXTENSIONS) {
                gribExtensions.add(s1 + "." + s2);
                allExtensions.add(s1 + "." + s2);
            }
        }
        NC_PLUS_EXTENSIONS = ncExtensions.toArray(new String[0]);
        HDF_PLUS_EXTENSIONS = hdfExtensions.toArray(new String[0]);
        GRIB_PLUS_EXTENSIONS = gribExtensions.toArray(new String[0]);
        ALL_PLUS_EXTENSIONS = allExtensions.toArray(new String[0]);
    }

    public static enum FilterType {
        NETCDF,
        HDF,
        GRIB,
        ALL;

    }
}

