/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarUtilities;
import gov.nasa.giss.netcdf.time.NcAbsoluteTime;
import gov.nasa.giss.netcdf.time.NcDataTime;
import gov.nasa.giss.netcdf.time.NcJulianTime;
import gov.nasa.giss.netcdf.time.NcRelativeTime;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.JulianType;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class NcDimensionVariable {
    private static Logger logger_ = LoggerFactory.getLogger(NcDimensionVariable.class);
    private static final PrintfFormat SFORMAT = new PrintfFormat("%G");
    private NcDataset dataset_;
    private Variable dimVar_;
    private String boundsName_;
    private Variable boundsVar_;
    private Variable edgesVar_;
    private int numCoordinates_;
    private String longName_;
    private String units_;
    private NcDataTime timeParser_;
    private Object[] values_;
    private String[] formattedValues_;
    private Object[][] bounds_;
    private String[] formattedBounds_;
    private boolean initted_;

    public NcDimensionVariable(NcDataset dataset, Variable var) throws IOException {
        if (dataset == null) {
            throw new IllegalArgumentException("Null dataset argument.");
        }
        if (var == null) {
            throw new IllegalArgumentException("Null variable argument.");
        }
        this.dataset_ = dataset;
        this.dimVar_ = var;
        this.longName_ = NcVarUtilities.getLongName(this.dimVar_);
        this.numCoordinates_ = this.dimVar_.getShape()[0];
        this.values_ = new Object[this.numCoordinates_];
        this.formattedValues_ = new String[this.numCoordinates_];
        this.units_ = NcVarUtilities.getUnits(this.dimVar_);
        if (this.units_.length() > 0) {
            String lcunits = this.units_.toLowerCase();
            if (lcunits.startsWith("degrees")) {
                if (lcunits.equals("degrees_east")) {
                    this.units_ = "\u00b0E";
                } else if (lcunits.equals("degrees_north")) {
                    this.units_ = "\u00b0N";
                } else if (lcunits.equals("degrees_west")) {
                    this.units_ = "\u00b0W";
                } else if (lcunits.equals("degrees_south")) {
                    this.units_ = "\u00b0S";
                }
            } else if (this.units_.indexOf(" since ") > 0) {
                try {
                    this.timeParser_ = new NcRelativeTime(this.dataset_, this.dimVar_);
                    this.units_ = "";
                }
                catch (Exception exc) {
                    this.timeParser_ = null;
                    exc.printStackTrace();
                }
            } else if (this.units_.equalsIgnoreCase("Julian Date") || this.units_.equalsIgnoreCase("Julian Day") || this.units_.equalsIgnoreCase("True Julian Date") || this.units_.equalsIgnoreCase("True Julian Day")) {
                try {
                    this.timeParser_ = new NcJulianTime();
                }
                catch (Exception exc) {
                    this.timeParser_ = null;
                    exc.printStackTrace();
                }
            } else if (this.units_.equalsIgnoreCase("Modified Julian Date") || this.units_.equalsIgnoreCase("Modified Julian Day")) {
                try {
                    this.timeParser_ = new NcJulianTime(JulianType.MODIFIED);
                }
                catch (Exception exc) {
                    this.timeParser_ = null;
                    exc.printStackTrace();
                }
            } else if (this.units_.indexOf(" as ") > 0) {
                try {
                    this.timeParser_ = new NcAbsoluteTime(this.dimVar_);
                    this.units_ = ((NcAbsoluteTime)this.timeParser_).getUnits();
                }
                catch (Exception exc) {
                    this.timeParser_ = null;
                    exc.printStackTrace();
                }
            }
        }
    }

    public String getLongName() {
        return this.longName_;
    }

    public String getUnits() {
        return this.units_;
    }

    public int getLength() {
        return this.values_.length;
    }

    public Object getValue(int index) {
        return this.values_[index];
    }

    public Object[] getValues() {
        if (!this.initted_) {
            this.initValues();
        }
        return this.values_;
    }

    public String[] getFormattedValues() {
        if (!this.initted_) {
            this.initValues();
        }
        return this.formattedValues_;
    }

    public boolean hasBounds() {
        if (!this.initted_) {
            this.initValues();
        }
        return this.bounds_ != null;
    }

    public Object[][] getBounds() {
        if (!this.initted_) {
            this.initValues();
        }
        return this.bounds_;
    }

    public String[] getFormattedBounds() {
        block6: {
            if (!this.initted_) {
                this.initValues();
            }
            if (this.bounds_ == null) {
                return null;
            }
            if (this.formattedBounds_ != null) break block6;
            this.formattedBounds_ = new String[this.values_.length];
            if (this.bounds_[0][0] instanceof Double) {
                for (int i = 0; i < this.values_.length; ++i) {
                    this.formattedBounds_[i] = SFORMAT.sprintf(this.bounds_[i][0]) + " \u2014 " + SFORMAT.sprintf(this.bounds_[i][1]);
                }
            } else {
                for (int i = 0; i < this.values_.length; ++i) {
                    this.formattedBounds_[i] = this.bounds_[i][0] + " \u2014 " + this.bounds_[i][1];
                }
            }
        }
        return this.formattedBounds_;
    }

    private void initValues() {
        block12: {
            try {
                DataType dtype = this.dimVar_.getDataType();
                if (this.timeParser_ != null) {
                    if (this.timeParser_ instanceof NcAbsoluteTime) {
                        this.initAbsoluteTimeValues();
                    } else if (this.timeParser_ instanceof NcRelativeTime) {
                        this.initRelativeTimeValues();
                    } else if (this.timeParser_ instanceof NcJulianTime) {
                        this.initJulianTimeValues();
                    }
                    break block12;
                }
                if (dtype == DataType.INT || dtype == DataType.SHORT) {
                    this.initIntegerValues();
                    break block12;
                }
                if (dtype == DataType.DOUBLE || dtype == DataType.FLOAT) {
                    this.initDoubleValues();
                    break block12;
                }
                if (dtype == DataType.CHAR) {
                    this.initCharValues();
                    break block12;
                }
                if (dtype == DataType.BOOLEAN) {
                    this.initBooleanValues();
                    break block12;
                }
                throw new NcException("Unknown data type in dimension: " + (Object)((Object)dtype));
            }
            catch (Exception exc) {
                throw new NcException("Could not init dim variable");
            }
        }
        this.initted_ = true;
    }

    private void initCharValues() throws IOException {
        Array dimArray = this.dimVar_.read();
        Index dimIndex = dimArray.getIndex();
        int[] shape = this.dimVar_.getShape();
        for (int i = 0; i < this.numCoordinates_; ++i) {
            char c;
            StringBuffer coordinate = new StringBuffer("");
            for (int ii = 0; ii < shape[1] && (c = dimArray.getChar(dimIndex.set(i, ii))) != '\u0000'; ++ii) {
                coordinate.append(c);
            }
            this.values_[i] = coordinate.toString();
            this.formattedValues_[i] = (String)this.values_[i];
        }
    }

    private void initBooleanValues() throws IOException {
        Array dimArray = this.dimVar_.read();
        Index dimIndex = dimArray.getIndex();
        for (int i = 0; i < this.numCoordinates_; ++i) {
            this.values_[i] = new Boolean(dimArray.getBoolean(dimIndex.set(i)));
            this.formattedValues_[i] = this.values_[i].toString();
        }
    }

    private void initDoubleValues() throws IOException {
        Array dimArray = this.dimVar_.read();
        Index dimIndex = dimArray.getIndex();
        double modulo = this.findModulo();
        for (int i = 0; i < this.numCoordinates_; ++i) {
            double value = dimArray.getDouble(dimIndex.set(i));
            this.values_[i] = new Double(value);
            this.formattedValues_[i] = SFORMAT.sprintf((Double)this.values_[i]);
        }
        this.findBoundsVariable();
        if (this.boundsVar_ != null) {
            Array boundsArray = this.boundsVar_.read();
            Index boundsIndex = boundsArray.getIndex();
            for (int i = 0; i < this.numCoordinates_; ++i) {
                double v1 = boundsArray.getDouble(boundsIndex.set(i, 0));
                double v2 = boundsArray.getDouble(boundsIndex.set(i, 1));
                if (modulo > 0.0) {
                    v1 %= modulo;
                    v2 %= modulo;
                }
                this.bounds_[i][0] = new Double(v1);
                this.bounds_[i][1] = new Double(v2);
            }
        }
    }

    private void initIntegerValues() throws IOException {
        Array dimArray = this.dimVar_.read();
        Index dimIndex = dimArray.getIndex();
        double modulo = this.findModulo();
        for (int i = 0; i < this.numCoordinates_; ++i) {
            int value = dimArray.getInt(dimIndex.set(i));
            this.values_[i] = new Integer(value);
            this.formattedValues_[i] = this.values_[i].toString();
        }
        this.findBoundsVariable();
        if (this.boundsVar_ != null) {
            Array boundsArray = this.boundsVar_.read();
            Index boundsIndex = boundsArray.getIndex();
            for (int i = 0; i < this.numCoordinates_; ++i) {
                int v1 = boundsArray.getInt(boundsIndex.set(i, 0));
                int v2 = boundsArray.getInt(boundsIndex.set(i, 1));
                if (modulo > 0.0) {
                    v1 %= (int)modulo;
                    v2 %= (int)modulo;
                }
                this.bounds_[i][0] = new Integer(v1);
                this.bounds_[i][1] = new Integer(v2);
            }
        }
    }

    private void initAbsoluteTimeValues() throws IOException {
        block8: {
            Array dimArray = this.dimVar_.read();
            Index dimIndex = dimArray.getIndex();
            if (this.dimVar_.getDataType() == DataType.INT) {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    int value = dimArray.getInt(dimIndex.set(i));
                    this.values_[i] = new Integer(value);
                    this.formattedValues_[i] = this.timeParser_.format(value);
                }
            } else {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    double value = dimArray.getDouble(dimIndex.set(i));
                    this.values_[i] = new Double(value);
                    this.formattedValues_[i] = this.timeParser_.format(value);
                }
            }
            this.findBoundsVariable();
            if (this.boundsVar_ == null) break block8;
            Array boundsArray = this.boundsVar_.read();
            Index boundsIndex = boundsArray.getIndex();
            if (this.dimVar_.getDataType() == DataType.INT) {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    int v1 = boundsArray.getInt(boundsIndex.set(i, 0));
                    int v2 = boundsArray.getInt(boundsIndex.set(i, 1));
                    this.bounds_[i][0] = this.timeParser_.format(v1);
                    this.bounds_[i][1] = this.timeParser_.format(v2);
                }
            } else {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    double v1 = boundsArray.getDouble(boundsIndex.set(i, 0));
                    double v2 = boundsArray.getDouble(boundsIndex.set(i, 1));
                    this.bounds_[i][0] = this.timeParser_.format(v1);
                    this.bounds_[i][1] = this.timeParser_.format(v2);
                }
            }
        }
    }

    private void initRelativeTimeValues() throws IOException {
        block11: {
            int i;
            Array dimArray = this.dimVar_.read();
            Index dimIndex = dimArray.getIndex();
            if (this.dimVar_.getDataType() == DataType.INT || this.dimVar_.getDataType() == DataType.SHORT) {
                for (int i2 = 0; i2 < this.numCoordinates_; ++i2) {
                    int value = dimArray.getInt(dimIndex.set(i2));
                    this.values_[i2] = new Integer(value);
                    this.formattedValues_[i2] = this.timeParser_.format(value);
                }
            } else if (this.dimVar_.getDataType() == DataType.LONG) {
                for (i = 0; i < this.numCoordinates_; ++i) {
                    long value = dimArray.getLong(dimIndex.set(i));
                    this.values_[i] = new Long(value);
                    this.formattedValues_[i] = this.timeParser_.format(value);
                }
            } else {
                for (i = 0; i < this.numCoordinates_; ++i) {
                    double value = dimArray.getDouble(dimIndex.set(i));
                    this.values_[i] = new Double(value);
                    this.formattedValues_[i] = this.timeParser_.format(value);
                }
            }
            this.findBoundsVariable();
            if (this.boundsVar_ == null) break block11;
            Array boundsArray = this.boundsVar_.read();
            Index boundsIndex = boundsArray.getIndex();
            if (this.dimVar_.getDataType() == DataType.INT) {
                for (int i3 = 0; i3 < this.numCoordinates_; ++i3) {
                    int v1 = boundsArray.getInt(boundsIndex.set(i3, 0));
                    int v2 = boundsArray.getInt(boundsIndex.set(i3, 1));
                    this.bounds_[i3][0] = this.timeParser_.format(v1);
                    this.bounds_[i3][1] = this.timeParser_.format(v2);
                }
            } else {
                for (int i4 = 0; i4 < this.numCoordinates_; ++i4) {
                    double v1 = boundsArray.getDouble(boundsIndex.set(i4, 0));
                    double v2 = boundsArray.getDouble(boundsIndex.set(i4, 1));
                    this.bounds_[i4][0] = this.timeParser_.format(v1);
                    this.bounds_[i4][1] = this.timeParser_.format(v2);
                }
            }
        }
    }

    private void initJulianTimeValues() throws IOException {
        block8: {
            Array dimArray = this.dimVar_.read();
            Index dimIndex = dimArray.getIndex();
            if (this.dimVar_.getDataType() == DataType.INT || this.dimVar_.getDataType() == DataType.SHORT) {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    int value = dimArray.getInt(dimIndex.set(i));
                    this.values_[i] = new Integer(value);
                    this.formattedValues_[i] = this.timeParser_.format(value);
                }
            } else {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    double value = dimArray.getDouble(dimIndex.set(i));
                    this.values_[i] = new Double(value);
                    this.formattedValues_[i] = this.timeParser_.format(value);
                }
            }
            this.findBoundsVariable();
            if (this.boundsVar_ == null) break block8;
            Array boundsArray = this.boundsVar_.read();
            Index boundsIndex = boundsArray.getIndex();
            if (this.dimVar_.getDataType() == DataType.INT || this.dimVar_.getDataType() == DataType.SHORT) {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    int v1 = boundsArray.getInt(boundsIndex.set(i, 0));
                    int v2 = boundsArray.getInt(boundsIndex.set(i, 1));
                    this.bounds_[i][0] = this.timeParser_.format(v1);
                    this.bounds_[i][1] = this.timeParser_.format(v2);
                }
            } else {
                for (int i = 0; i < this.numCoordinates_; ++i) {
                    double v1 = boundsArray.getDouble(boundsIndex.set(i, 0));
                    double v2 = boundsArray.getDouble(boundsIndex.set(i, 1));
                    this.bounds_[i][0] = this.timeParser_.format(v1);
                    this.bounds_[i][1] = this.timeParser_.format(v2);
                }
            }
        }
    }

    private double findModulo() {
        double modulo = 0.0;
        if (this.dimVar_.findAttribute("topology") != null && this.dimVar_.findAttribute("topology").getStringValue().equals("circular") && this.dimVar_.findAttribute("modulo") != null) {
            modulo = this.dimVar_.findAttribute("modulo").getNumericValue().doubleValue();
        }
        return modulo;
    }

    private void findBoundsVariable() {
        Attribute ba;
        if (this.boundsName_ == null && (ba = this.dimVar_.findAttribute("bounds")) != null) {
            this.boundsName_ = ba.getStringValue();
        }
        if (this.boundsName_ == null && (ba = this.dimVar_.findAttribute("climatology")) != null) {
            this.boundsName_ = ba.getStringValue();
        }
        if (this.boundsName_ != null) {
            this.boundsVar_ = this.dataset_.findVariable(this.boundsName_);
        }
        if (this.boundsVar_ != null) {
            int rank = this.boundsVar_.getRank();
            int[] shape = this.boundsVar_.getShape();
            if (this.boundsVar_.getRank() == 2 && shape[0] == this.numCoordinates_ && shape[1] == 2) {
                this.bounds_ = new Object[this.numCoordinates_][2];
            } else {
                logger_.warn("Dimension variable {} has unintelligible bounds.", (Object)this.dimVar_.getFullName());
                this.boundsVar_ = null;
            }
        }
        if (this.bounds_ != null) {
            String edgesName = null;
            try {
                edgesName = this.dimVar_.findAttribute("edges").getStringValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (edgesName != null) {
                this.edgesVar_ = this.dataset_.findVariable(edgesName);
            }
        }
    }
}

