/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimensionVariable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcDimension {
    private static Logger logger_ = LoggerFactory.getLogger(NcDimension.class);
    private Dimension dimension_;
    private NcDimensionVariable dimVar_;
    private String[] values_;
    private String longName_;
    private String units_;

    public NcDimension(NcDataset dataset, VariableDS varDS, Dimension dimension) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null dataset argument.");
        }
        if (dimension == null) {
            throw new IllegalArgumentException("Null dimension argument.");
        }
        this.dimension_ = dimension;
        VariableDS cv = null;
        List<CoordinateSystem> csList = null;
        csList = varDS == null ? dataset.getDataset().getCoordinateSystems() : varDS.getCoordinateSystems();
        for (CoordinateSystem cs : csList) {
            List<CoordinateAxis> axesList = cs.getCoordinateAxes();
            for (CoordinateAxis axis : axesList) {
                Dimension dx;
                if (!(axis instanceof CoordinateAxis1D) || !(dx = axis.getDimension(0)).equals(dimension)) continue;
                cv = axis;
                break;
            }
            if (cv == null) continue;
            break;
        }
        if (cv == null) {
            String dname = dimension.getName();
            cv = dataset.findVariable(dname);
        }
        try {
            this.dimVar_ = cv != null ? new NcDimensionVariable(dataset, cv) : null;
        }
        catch (Exception exc) {
            logger_.error("Exc {}", (Object)exc.toString());
            exc.printStackTrace();
            this.dimVar_ = null;
        }
        int numCoordinates = this.dimension_.getLength();
        this.values_ = new String[numCoordinates];
        if (this.dimVar_ == null) {
            for (int i = 0; i < numCoordinates; ++i) {
                this.values_[i] = i + 1 + " of " + numCoordinates;
            }
        }
    }

    public String getLongName() {
        if (this.longName_ == null) {
            String defaultName = this.dimension_.getName();
            StringBuffer nameBuffer = new StringBuffer("");
            if (this.dimVar_ == null) {
                nameBuffer.append(defaultName);
            } else {
                nameBuffer.append(this.dimVar_.getLongName());
            }
            if (nameBuffer.length() > 0) {
                nameBuffer.setCharAt(0, Character.toUpperCase(nameBuffer.charAt(0)));
            }
            this.longName_ = nameBuffer.toString();
        }
        return this.longName_;
    }

    public String getUnits() {
        if (this.units_ == null) {
            this.units_ = this.dimVar_ == null ? "" : this.dimVar_.getUnits();
        }
        return this.units_;
    }

    public int getLength() {
        return this.values_.length;
    }

    public Object getValue(int index) {
        if (this.dimVar_ == null) {
            return this.values_[index];
        }
        return this.dimVar_.getValue(index);
    }

    public Object[] getValues() {
        if (this.dimVar_ == null) {
            return this.values_;
        }
        return this.dimVar_.getValues();
    }

    public String[] getFormattedValues() {
        if (this.dimVar_ == null) {
            return this.values_;
        }
        return this.dimVar_.getFormattedValues();
    }

    public boolean hasBounds() {
        if (this.dimVar_ == null) {
            return false;
        }
        return this.dimVar_.hasBounds();
    }

    public Object[][] getBounds() {
        if (this.dimVar_ == null) {
            return null;
        }
        return this.dimVar_.getBounds();
    }

    public String[] getFormattedBounds() {
        if (this.dimVar_ == null) {
            return null;
        }
        return this.dimVar_.getFormattedBounds();
    }
}

