/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.graphics.colortable.SimpleColorTable;
import gov.nasa.giss.netcdf.NcFilenameFilter;
import gov.nasa.giss.netcdf.NcGeometryType;
import gov.nasa.giss.netcdf.NcHdfPalette;
import gov.nasa.giss.netcdf.NcNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class NcDataset
extends NcNode {
    private static Logger logger_ = LoggerFactory.getLogger(NcDataset.class);
    private static boolean DEVO_UNENHANCED = false;
    private NetcdfDataset ncd_;
    private URL url_;
    private String name_ = null;
    private NcGeometryType geometry = NcGeometryType.GRIDDED;

    public NcDataset(File f) throws IOException, FileNotFoundException, MalformedURLException {
        this.init(f.toURI().toURL());
    }

    public NcDataset(URL url) throws IOException, FileNotFoundException {
        this.init(url);
    }

    private void init(URL url) throws IOException {
        String ft;
        this.url_ = url;
        this.name_ = url.getFile();
        int lastSep = this.name_.lastIndexOf("/");
        if (lastSep > -1) {
            this.name_ = this.name_.substring(lastSep + 1);
        }
        try {
            if (DEVO_UNENHANCED) {
                logger_.info("Trying to acquire dataset in UNENHANCED mode");
                this.ncd_ = NetcdfDataset.acquireDataset(this.url_.toString(), false, null);
            } else {
                this.ncd_ = NetcdfDataset.acquireDataset(this.url_.toString(), true, null);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            String msg = exc.toString().replaceFirst(".*Could not find a table for GRIB file with ", "Could not find a GRIB table for ");
            throw new IOException("Failed to acquire " + this.name_ + ":\n" + msg + ".");
        }
        this.dataset_ = this;
        Attribute a = this.findGlobalAttribute("featureType");
        if (a != null && (ft = a.getStringValue()).equals("trajectory")) {
            this.geometry = NcGeometryType.TRAJECTORY;
        }
        this.group_ = this.ncd_.getRootGroup();
        NcDataset.initChildrenFromGroup(this.dataset_, this, this.group_, this.showOnlyPlottables_);
    }

    public String getNcFileTypeID() {
        return this.ncd_.getFileTypeId();
    }

    public URL getURL() {
        return this.url_;
    }

    public NetcdfDataset getDataset() {
        return this.ncd_;
    }

    public NcGeometryType getGeometry() {
        return this.geometry;
    }

    public Dimension findDimension(String name) {
        return this.ncd_.findDimension(name);
    }

    public Attribute findGlobalAttribute(String name) {
        return this.ncd_.findGlobalAttribute(name);
    }

    public VariableDS findVariable(String name) {
        return (VariableDS)this.ncd_.findVariable(name);
    }

    public void close() throws IOException {
        this.ncd_.close();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getNcType() {
        String s = this.url_.toString().toLowerCase();
        if (s.startsWith("file:")) {
            return "Local File";
        }
        if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
            return "Remote File";
        }
        return "-";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>File \"").append(this.getName()).append("\"</h2>\n");
        try {
            String desc = this.ncd_.getIosp().getFileTypeDescription();
            sb.append("<p>Dataset type: ").append(desc).append("</p>\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append(StringEscapeUtils.escapeHtml4(this.ncd_.toString()));
        sb.append("\n");
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public String getNameRoot() {
        String[] extensions = NcFilenameFilter.getExtensions();
        String lcname = this.name_.toLowerCase();
        for (String s : extensions) {
            if (!lcname.endsWith("." + s.toLowerCase())) continue;
            return this.name_.substring(0, this.name_.length() - s.length() - 1);
        }
        return this.name_;
    }

    public AbstractColorTable[] getColorTables() {
        Vector<SimpleColorTable> pvector = new Vector<SimpleColorTable>(10);
        List<Variable> vars = this.ncd_.getVariables();
        for (Variable o : vars) {
            if (!(o instanceof VariableDS)) continue;
            try {
                VariableDS vds = (VariableDS)o;
                Attribute classAttr = vds.findAttribute("CLASS");
                if (classAttr == null || !classAttr.getStringValue().equals("PALETTE")) continue;
                SimpleColorTable act = new NcHdfPalette(this, vds).getColorTable();
                pvector.add(act);
            }
            catch (Exception ignore) {}
        }
        return pvector.toArray(new AbstractColorTable[0]);
    }

    public void printCdl(File f) throws IOException {
        PrintWriter writer = new PrintWriter(f);
        NCdumpW.print(this.ncd_.getReferencedFile(), (Writer)writer, true, false, false, true, "", null);
        writer.close();
    }
}

