/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalogNode;
import java.net.URI;
import java.util.Iterator;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;

public class NcCatalogDataset
extends NcCatalogNode {
    private InvDataset dataset_;
    private boolean childrenInitialized_;
    private boolean isTrueDataset_;
    private URI uri_;
    private boolean isSimpleDataset_;

    private NcCatalogDataset() {
    }

    private NcCatalogDataset(InvDataset dataset) {
        this(null, dataset);
    }

    public NcCatalogDataset(NcCatalogNode parent, InvDataset dataset) {
        this.setParent(parent);
        this.dataset_ = dataset;
        this.initURI();
    }

    private void initURI() {
        InvAccess access;
        InvAccess info;
        InvService dservice = this.dataset_.getServiceDefault();
        ServiceType dstype = dservice != null ? dservice.getServiceType() : null;
        Iterator<InvAccess> i$ = this.dataset_.getAccess().iterator();
        while (i$.hasNext()) {
            access = info = i$.next();
            DataFormatType dft = access.getDataFormatType();
            InvService service = access.getService();
            if (service == null) continue;
            ServiceType stype = service.getServiceType();
            if (dstype != null && !stype.equals(dstype)) continue;
            this.isSimpleDataset_ = true;
            this.uri_ = access.getStandardUri();
            return;
        }
        i$ = this.dataset_.getAccess().iterator();
        if (i$.hasNext()) {
            access = info = i$.next();
            this.isSimpleDataset_ = true;
            this.uri_ = access.getStandardUri();
            return;
        }
    }

    private synchronized void initChildren() {
        Iterator<InvDataset> i$ = this.dataset_.getDatasets().iterator();
        while (i$.hasNext()) {
            InvDataset o;
            InvDataset d = o = i$.next();
            super.add(new NcCatalogDataset(this, d));
        }
        this.childrenInitialized_ = true;
    }

    public String getCatalogURL() {
        return this.dataset_.getCatalogUrl();
    }

    public URI getURI() {
        return this.uri_;
    }

    @Override
    public boolean isLeaf() {
        return this.isSimpleDataset_;
    }

    public boolean hasChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        if (this.dataset_ instanceof InvCatalogRef) {
            return true;
        }
        return this.getChildCount() > 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isSimpleDataset_;
    }

    @Override
    public Object getObject() {
        return this.dataset_;
    }

    @Override
    public String getName() {
        return this.dataset_.getName();
    }

    @Override
    public String getLongName() {
        return this.dataset_.getFullName();
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head>");
        sb.append("<style type=\"text/css\"><!-- ");
        sb.append("body { padding: 8px; margin: 80x }");
        sb.append("body h2 { font-family: sans-serif; font-size: 12px; padding-bottom: 2px } ");
        sb.append("body p { font-size: 10px; font-family: sans-serif } ");
        sb.append("body pre { font-size: 10px } ");
        sb.append("body hr { border: none; background-color: #999; color: #999; height: 1px } ");
        sb.append("// --></style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>");
        if (this.getAllowsChildren()) {
            sb.append("Catalog Branch \"");
        } else {
            sb.append("Dataset \"");
        }
        sb.append(this.getName()).append("\"</h2>\n");
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append("Full Name:       ").append(this.dataset_.getFullName()).append("\n");
        if (this.dataset_.getCatalogUrl() != null) {
            sb.append("Catalog URL:     ").append(this.dataset_.getCatalogUrl()).append("\n");
        }
        if (this.dataset_.getID() != null) {
            sb.append("ID:              ").append(this.dataset_.getID()).append("\n");
        }
        if (this.dataset_.getDataFormatType() != null) {
            sb.append("Data FormatType: ").append(this.dataset_.getDataFormatType()).append("\n");
        }
        if (this.dataset_.getDataType() != null) {
            sb.append("Data Type:       ").append((Object)this.dataset_.getDataType()).append("\n");
        }
        Iterator<InvAccess> i$ = this.dataset_.getAccess().iterator();
        while (i$.hasNext()) {
            InvAccess info;
            InvAccess md = info = i$.next();
            sb.append("\n");
            sb.append("Access-Service:  ").append(md.getService().getServiceType()).append("\n");
            sb.append("Access-URI:      ").append("<a href=").append(md.getStandardUri()).append(">").append(md.getStandardUri()).append("</a>").append("\n");
        }
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public int getChildCount() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildCount();
    }

    @Override
    public TreeTableNode getChildAt(int index) {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildAt(index);
    }

    @Override
    public TreeTableNode[] getChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildren();
    }

    @Override
    public void add(TreeTableNode child) throws IllegalStateException {
        if (child == null) {
            throw new IllegalArgumentException("Can't insert a null.");
        }
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        super.add(child);
    }
}

