/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.gui.treetable.TreeTableNode;
import gov.nasa.giss.netcdf.NcCatalogDataset;
import gov.nasa.giss.netcdf.NcCatalogNode;
import gov.nasa.giss.netcdf.NcException;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;

public class NcCatalog
extends NcCatalogNode {
    private static Logger logger_ = LoggerFactory.getLogger(NcCatalog.class);
    private static InvCatalogFactory factory_;
    private InvCatalogImpl catImpl_;
    private boolean childrenInitialized_;

    public NcCatalog(NcCatalogNode parent, URI uri) throws FileNotFoundException {
        this.setParent(parent);
        if (factory_ == null) {
            factory_ = InvCatalogFactory.getDefaultFactory(true);
        }
        this.catImpl_ = factory_.readXML(uri);
        StringBuilder sb = new StringBuilder();
        if (!this.catImpl_.check(sb, false)) {
            String s = sb.toString();
            if (s.indexOf("FileNotFoundException") > -1) {
                throw new FileNotFoundException(uri.toString());
            }
            if (s.indexOf("JDOMParseException") > -1) {
                throw new NcException("Server response does not look like good catalog XML.");
            }
            throw new NcException(sb.toString());
        }
    }

    private void initChildren() {
        Iterator<InvDataset> i$ = this.catImpl_.getDatasets().iterator();
        while (i$.hasNext()) {
            InvDataset o;
            InvDataset d = o = i$.next();
            super.add(new NcCatalogDataset(this, d));
        }
        this.childrenInitialized_ = true;
    }

    public URI getURI() {
        return this.catImpl_.getBaseURI();
    }

    @Override
    public String toString() {
        String name = this.catImpl_.getName();
        if (name == null) {
            name = "[" + this.catImpl_.getBaseURI().getHost() + "]";
        }
        return name;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this.catImpl_;
    }

    @Override
    public String getName() {
        return this.catImpl_.getName();
    }

    @Override
    public String getLongName() {
        return this.catImpl_.getName();
    }

    @Override
    public String getDetail() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style type=\"text/css\"><!-- ");
        sb.append("body { padding: 8px; margin: 80x }");
        sb.append("body h2 { font-family: sans-serif; font-size: 12px; padding-bottom: 2px } ");
        sb.append("body p { font-size: 10px; font-family: sans-serif } ");
        sb.append("body pre { font-size: 10px } ");
        sb.append("body hr { border: none; background-color: #999; color: #999; height: 1px } ");
        sb.append("// --></style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>Catalog \"").append(this.getName()).append("\"</h2>\n");
        sb.append("<hr>");
        sb.append("<pre>");
        sb.append("Base URI: ").append(this.catImpl_.getBaseURI()).append("\n");
        sb.append("</pre>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public int getChildCount() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildCount();
    }

    @Override
    public TreeTableNode getChildAt(int index) {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildAt(index);
    }

    @Override
    public TreeTableNode[] getChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildren();
    }

    @Override
    public void add(TreeTableNode child) throws IllegalStateException {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        super.add(child);
    }
}

