/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArrayGridException;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.text.PrintfFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;

public abstract class NcArray2D
extends NcArray {
    private static Logger logger_ = LoggerFactory.getLogger(NcArray2D.class);
    private static final int MAX_ELEMENTS = 14000000;
    private static final int MAX_CHUNK_ELEMENTS = 12000000;
    private static final int MIN_ROWS = 24;
    protected NcAxis xAxis_;
    protected NcAxis yAxis_;
    protected int xDimIndex_ = -1;
    protected int yDimIndex_ = -1;
    protected int aveDimIndex_ = -1;
    private int numCols_ = -1;
    private int numRows_ = -1;
    private int numAves_ = -1;
    private int maxRows_;
    private int maxAveSlices_;
    private int rowOffset_;
    private int sectionRows_;
    private double[][] averages_;

    public NcArray2D(NcDataset dataset, String varname) throws NcException {
        super(dataset, varname);
        this.init();
    }

    public NcArray2D(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.init();
    }

    private void init() {
        this.setAxes();
        this.measure();
        if (this.aveDimIndex_ > -1) {
            this.setSliceIndex(this.aveDimIndex_, -1);
        }
    }

    protected abstract void setAxes();

    private void measure() {
        if (this.xDimIndex_ < 0) {
            throw new NcArrayGridException("X-dimension index is not set.");
        }
        if (this.yDimIndex_ < 0) {
            throw new NcArrayGridException("Y-dimension index is not set.");
        }
        this.numCols_ = this.shape_[this.xDimIndex_];
        this.numRows_ = this.shape_[this.yDimIndex_];
        int total = this.numCols_ * this.numRows_;
        if (total < 14000000) {
            this.maxRows_ = this.numRows_;
        } else {
            this.maxRows_ = this.numRows_ / (total / 12000000);
            this.maxRows_ = this.maxRows_ / 100 * 100;
        }
        this.maxRows_ = Math.max(this.maxRows_, 24);
        this.maxRows_ = Math.min(this.maxRows_, this.numRows_);
        if (this.maxRows_ == this.numRows_ && this.aveDimIndex_ > -1) {
            this.numAves_ = this.shape_[this.aveDimIndex_];
            this.maxAveSlices_ = 12000000 / (this.maxRows_ * this.numCols_);
            this.maxAveSlices_ = Math.max(this.maxAveSlices_, 1);
            this.maxAveSlices_ = Math.min(this.maxAveSlices_, this.numAves_);
        }
    }

    @Override
    protected void createDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.xDimIndex_ || i == this.yDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public int getWidth() {
        return this.numCols_;
    }

    public int getHeight() {
        return this.numRows_;
    }

    public NcAxis getXAxis() {
        return this.xAxis_;
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    @Override
    public boolean isAveragingDimension(int dimIndex) {
        return dimIndex == this.aveDimIndex_;
    }

    public boolean hasAveragingDimension() {
        return this.aveDimIndex_ > -1;
    }

    public double valueAt(int col, int row) {
        if (row < 0 || row >= this.numRows_) {
            throw new IllegalArgumentException("Row index out of range: " + row + " : " + this.numRows_);
        }
        if (col < 0 || col >= this.numCols_) {
            throw new IllegalArgumentException("Column index out of range: " + col + " : " + this.numCols_);
        }
        if (this.aveDimIndex_ > -1 && this.sIndex_[this.aveDimIndex_] == -1) {
            return this.dimensionAverageAt(col, row);
        }
        if (this.needsSlice_ || this.slice_ == null || row < this.rowOffset_ - 1 || row >= this.rowOffset_ + this.maxRows_) {
            this.doSlice(row);
        }
        try {
            int offRow = row - this.rowOffset_;
            return this.getDoubleFromSlice(col, offRow, -1);
        }
        catch (Exception exc) {
            logger_.error("Slice getDouble failed -  row,col = {}.{}", (Object)row, (Object)col);
            exc.printStackTrace();
            throw new NcException(exc.toString());
        }
    }

    public double dimensionAverageAt(int col, int row) throws NcException {
        if (this.aveDimIndex_ == -1) {
            throw new NcException("Dimension averaging not set up for this array.");
        }
        if (this.averages_ == null || row < this.rowOffset_ - 1 || row >= this.rowOffset_ + this.maxRows_) {
            this.doAverage(row);
        }
        return this.averages_[row - this.rowOffset_][col];
    }

    private synchronized void doSlice(int row) throws NcException {
        this.rowOffset_ = this.maxRows_ * (row / this.maxRows_);
        if (this.rowOffset_ > row - 2) {
            this.rowOffset_ = Math.max(row - 2, 0);
        }
        this.sectionRows_ = this.rowOffset_ + this.maxRows_ > this.numRows_ ? this.numRows_ - this.rowOffset_ : this.maxRows_;
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.xDimIndex_] = 0;
            sOrigin[this.yDimIndex_] = this.yAxis_.isFlipped() ? this.numRows_ - this.rowOffset_ - this.sectionRows_ : this.rowOffset_;
            sShape[this.xDimIndex_] = this.numCols_;
            sShape[this.yDimIndex_] = this.sectionRows_;
            this.slice_ = this.varDS_.read(sOrigin, sShape);
            if (this.xAxis_.isFlipped()) {
                this.slice_ = this.slice_.flip(this.xDimIndex_);
            }
            if (this.yAxis_.isFlipped()) {
                this.slice_ = this.slice_.flip(this.yDimIndex_);
            }
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Do Slice - " + exc.toString());
        }
    }

    private void doAverage(int row) throws NcException {
        if (this.aveDimIndex_ < 0) {
            throw new NcException("Array has no averaging dimension.");
        }
        this.slice_ = null;
        if (this.averages_ == null) {
            this.averages_ = new double[this.maxRows_][this.numCols_];
        }
        this.rowOffset_ = this.maxRows_ * (row / this.maxRows_);
        if (this.rowOffset_ > row - 2) {
            this.rowOffset_ = Math.max(row - 2, 0);
        }
        this.sectionRows_ = this.rowOffset_ + this.maxRows_ > this.numRows_ ? this.numRows_ - this.rowOffset_ : this.maxRows_;
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        int[][] aveCount = new int[this.sectionRows_][this.numCols_];
        for (int k = 0; k < this.sectionRows_; ++k) {
            for (int j = 0; j < this.numCols_; ++j) {
                this.averages_[k][j] = 0.0;
                aveCount[k][j] = 0;
            }
        }
        int xsize = this.xAxis_.getSize();
        try {
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.xDimIndex_] = 0;
            sOrigin[this.yDimIndex_] = this.yAxis_.isFlipped() ? this.numRows_ - this.rowOffset_ - this.sectionRows_ : this.rowOffset_;
            sShape[this.xDimIndex_] = this.numCols_;
            sShape[this.yDimIndex_] = this.sectionRows_;
            for (int iave = 0; iave < this.numAves_; iave += this.maxAveSlices_) {
                int aveSlices = iave + this.maxAveSlices_ >= this.numAves_ ? this.numAves_ - iave : this.maxAveSlices_;
                sOrigin[this.aveDimIndex_] = iave;
                sShape[this.aveDimIndex_] = aveSlices;
                this.slice_ = this.varDS_.read(sOrigin, sShape);
                if (this.xAxis_.isFlipped()) {
                    this.slice_ = this.slice_.flip(this.xDimIndex_);
                }
                if (this.yAxis_.isFlipped()) {
                    this.slice_ = this.slice_.flip(this.yDimIndex_);
                }
                this.sliceIdx_ = this.slice_.getIndex();
                for (int mm = 0; mm < aveSlices; ++mm) {
                    for (int k = 0; k < this.sectionRows_; ++k) {
                        for (int j = 0; j < xsize; ++j) {
                            double dval = this.getDoubleFromSlice(j, k, mm);
                            if (this.isMissingOrInvalid(dval)) continue;
                            double[] dArray = this.averages_[k];
                            int n = j;
                            dArray[n] = dArray[n] + dval;
                            int[] nArray = aveCount[k];
                            int n2 = j;
                            nArray[n2] = nArray[n2] + 1;
                        }
                    }
                }
                this.slice_ = null;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new NcException("Do Average: " + exc.toString());
        }
        for (int k = 0; k < this.sectionRows_; ++k) {
            for (int j = 0; j < xsize; ++j) {
                if (aveCount[k][j] == 0) {
                    this.averages_[k][j] = Double.NaN;
                    continue;
                }
                if (aveCount[k][j] <= 1) continue;
                double[] dArray = this.averages_[k];
                int n = j;
                dArray[n] = dArray[n] / (double)aveCount[k][j];
            }
        }
        this.needsSlice_ = false;
    }

    public double rowAverageOf(int row) throws NcException {
        double result = 0.0;
        int count = 0;
        for (int i = 0; i < this.numCols_; ++i) {
            double value = this.valueAt(i, row);
            if (Double.isNaN(value)) continue;
            result += value;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return result;
        }
        return result /= (double)count;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum != this.aveDimIndex_ || index == -1) {
            this.averages_ = null;
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    protected void findExtrema() {
        double[] range;
        if (this.rank_ < 3 && (range = this.getActualRange()) != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int j = 0; j < this.numRows_; ++j) {
                for (int i = 0; i < this.numCols_; ++i) {
                    double value = this.valueAt(i, j);
                    if (Double.isNaN(value) || this.isMissingOrInvalid(value)) continue;
                    if (this.maximum_ < this.minimum_) {
                        this.minimum_ = value;
                        this.maximum_ = value;
                        continue;
                    }
                    if (value < this.minimum_) {
                        this.minimum_ = value;
                        continue;
                    }
                    if (!(value > this.maximum_)) continue;
                    this.maximum_ = value;
                }
            }
        }
        catch (Exception exc) {
            logger_.error(exc.toString());
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    public abstract void describeCell(int var1, int var2, StringBuilder var3, PrintfFormat var4);

    private double getDoubleFromSlice(int col, int row, int ave) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.xDimIndex_] = col;
        ss[this.yDimIndex_] = row;
        if (ave > -1) {
            ss[this.aveDimIndex_] = ave;
        }
        this.sliceIdx_.set(ss);
        if (!this.hasScaleOffset_) {
            if (this.slice_ instanceof ArrayByte) {
                long v = this.slice_.getByte(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 256L;
                }
                return v;
            }
            if (this.slice_ instanceof ArrayShort) {
                long v = this.slice_.getShort(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 65536L;
                }
                return v;
            }
            if (this.slice_ instanceof ArrayInt) {
                long v = this.slice_.getInt(this.sliceIdx_);
                if (this.isUnsigned_ && v < 0L) {
                    v += 0x100000000L;
                }
                return v;
            }
        }
        return this.slice_.getDouble(this.sliceIdx_);
    }
}

