/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NcAxisType;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcException;
import gov.nasa.giss.netcdf.NcVarUtilities;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.netcdf.gridder.NcGridder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.units.Unit;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;

public abstract class NcArray {
    private static Logger logger_ = LoggerFactory.getLogger(NcArray.class);
    protected static UnitFormat unitFormat_ = null;
    protected NcDataset dataset_;
    protected NcVariable ncvar_;
    protected VariableDS varDS_;
    private CoordinateSystem coordSystem_;
    protected int[] shape_;
    protected Array slice_;
    protected Index sliceIdx_;
    protected boolean hasBad_;
    protected boolean hasMissing_;
    protected boolean hasInvalid_;
    protected boolean hasFill_;
    protected boolean hasScaleOffset_;
    protected boolean isUnsigned_;
    protected boolean isInteger_;
    protected boolean hasCorrectedFill_;
    protected long correctedFillValue_;
    private double validMax_ = Double.MAX_VALUE;
    private double validMin_ = -this.validMax_;
    protected int rank_;
    protected NcDimension[] dimensions_;
    protected int[] sIndex_;
    protected boolean needsSlice_ = true;
    protected double minimum_ = Double.NaN;
    protected double maximum_ = Double.NaN;
    protected boolean needsExtrema_ = true;

    public NcArray(NcDataset dataset, String vname) throws NcException {
        if (dataset == null) {
            throw new IllegalArgumentException("Null dataset argument.");
        }
        if (vname == null) {
            throw new IllegalArgumentException("Null variable name argument.");
        }
        this.dataset_ = dataset;
        try {
            this.ncvar_ = new NcVariable(dataset, vname);
        }
        catch (Exception exc) {
            throw new NcException("No variable by that name.");
        }
        this.varDS_ = (VariableDS)this.ncvar_.getObject();
        this.initMe();
    }

    public NcArray(NcVariable ncvar) throws NcException {
        if (ncvar == null) {
            throw new IllegalArgumentException("Null variable argument.");
        }
        this.dataset_ = ncvar.getDataset();
        this.ncvar_ = ncvar;
        this.varDS_ = (VariableDS)ncvar.getObject();
        this.initMe();
    }

    private void initMe() throws NcException {
        List<CoordinateSystem> l;
        Attribute aa;
        if (!this.ncvar_.isPlottable()) {
            throw new NcException("Does not seem to be a plottable variable");
        }
        this.rank_ = this.varDS_.getRank();
        this.shape_ = this.varDS_.getShape();
        this.sIndex_ = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.sIndex_[i] = 0;
        }
        this.hasBad_ = this.varDS_.hasMissing();
        this.hasMissing_ = this.varDS_.hasMissingValue();
        this.hasInvalid_ = this.varDS_.hasInvalidData();
        this.hasFill_ = this.varDS_.hasFillValue();
        this.hasScaleOffset_ = this.varDS_.hasScaleOffset();
        this.isUnsigned_ = this.varDS_.isUnsigned();
        DataType dt = this.varDS_.getDataType();
        boolean bl = this.isInteger_ = dt == DataType.BYTE || dt == DataType.SHORT || dt == DataType.INT || dt == DataType.LONG;
        if (this.hasInvalid_) {
            this.validMax_ = this.varDS_.getValidMax();
            this.validMin_ = this.varDS_.getValidMin();
            if (this.validMax_ > 0.0) {
                this.validMax_ *= 1.000001;
            } else if (this.validMax_ < 0.0) {
                this.validMax_ *= 0.999999;
            }
            if (this.validMin_ > 0.0) {
                this.validMin_ *= 0.999999;
            } else if (this.validMin_ < 0.0) {
                this.validMin_ *= 1.000001;
            }
        }
        if (this.hasFill_ && (aa = this.varDS_.findAttribute("_FillValue")) != null) {
            Number nval = aa.getNumericValue();
            if (this.isInteger_) {
                long lval = nval.longValue();
                if (this.isUnsigned_ && lval < 0L) {
                    this.hasCorrectedFill_ = true;
                    if (dt == DataType.BYTE) {
                        lval += 256L;
                    } else if (dt == DataType.SHORT) {
                        lval += 65536L;
                    } else if (dt == DataType.INT) {
                        lval += 0x100000000L;
                    }
                    this.correctedFillValue_ = lval;
                }
            }
        }
        if ((l = this.varDS_.getCoordinateSystems()).size() > 1) {
            logger_.warn("More than one coordinate system in dataset");
        }
        if (l.size() > 0) {
            this.coordSystem_ = l.get(0);
        }
    }

    protected int findDimensionIndex(String varname) {
        if (varname == null || varname.length() == 0) {
            return -1;
        }
        return this.varDS_.findDimensionIndex(varname);
    }

    protected int findDimensionIndex(VariableDS dimvar) {
        Attribute aa;
        if (dimvar == null) {
            return -1;
        }
        int vi = this.findDimensionIndex(dimvar.getFullName());
        if (vi < 0 && (aa = dimvar.findAttribute("_CoordinateAliasForDimension")) != null) {
            String aname = aa.getStringValue();
            vi = this.varDS_.findDimensionIndex(aname);
        }
        if (vi < 0 && dimvar.getRank() == 1) {
            Dimension dd = dimvar.getDimension(0);
            for (int i = 0; i < this.varDS_.getRank(); ++i) {
                if (!this.varDS_.getDimension(i).equals(dd)) continue;
                vi = i;
                break;
            }
        }
        return vi;
    }

    protected CoordinateAxis getCoordinateAxis(NcAxisType axisType) {
        if (this.coordSystem_ == null) {
            return null;
        }
        switch (axisType) {
            case LATITUDE: {
                CoordinateAxis lat = this.coordSystem_.getLatAxis();
                if (lat == null) {
                    for (int i = 0; i < this.rank_; ++i) {
                        VariableDS v;
                        Dimension d = this.varDS_.getDimension(i);
                        String name = d.getName();
                        if (name == null || (v = this.getDataset().findVariable(name)) == null || !NcVarUtilities.isLatitudeVar(v)) continue;
                        lat = new CoordinateAxis1D(this.getDataset().getDataset(), v);
                        lat.setAxisType(AxisType.Lat);
                    }
                }
                return lat;
            }
            case LONGITUDE: {
                CoordinateAxis lon = this.coordSystem_.getLonAxis();
                if (lon == null) {
                    for (int i = 0; i < this.rank_; ++i) {
                        VariableDS v;
                        Dimension d = this.varDS_.getDimension(i);
                        String name = d.getName();
                        if (name == null || (v = this.getDataset().findVariable(name)) == null || !NcVarUtilities.isLongitudeVar(v)) continue;
                        lon = new CoordinateAxis1D(this.getDataset().getDataset(), v);
                        lon.setAxisType(AxisType.Lon);
                    }
                }
                return lon;
            }
            case VERTICAL: {
                if (!this.coordSystem_.hasVerticalAxis()) {
                    return null;
                }
                CoordinateAxis vertAxis = this.coordSystem_.getPressureAxis();
                if (vertAxis == null) {
                    vertAxis = this.coordSystem_.getHeightAxis();
                }
                if (vertAxis == null) {
                    vertAxis = this.coordSystem_.getZaxis();
                }
                return vertAxis;
            }
            case TIME: {
                CoordinateAxis tAxis = this.coordSystem_.getTaxis();
                if (tAxis == null) {
                    for (int i = 0; i < this.rank_; ++i) {
                        VariableDS v;
                        Dimension d = this.varDS_.getDimension(i);
                        String name = d.getName();
                        if (name == null || (v = this.getDataset().findVariable(name)) == null || !NcVarUtilities.isAbsoluteTimeVar(v)) continue;
                        tAxis = new CoordinateAxis1D(this.getDataset().getDataset(), v);
                        tAxis.setAxisType(AxisType.Time);
                    }
                }
                return tAxis;
            }
            case GEOX: {
                return this.coordSystem_.getXaxis();
            }
            case GEOY: {
                return this.coordSystem_.getYaxis();
            }
        }
        return null;
    }

    protected abstract void createDimensions();

    public NcDimension[] getDimensions() {
        if (this.dimensions_ == null) {
            this.createDimensions();
        }
        return this.dimensions_;
    }

    public boolean hasFreeDimensions() {
        if (this.dimensions_ == null) {
            this.createDimensions();
        }
        for (int i = 0; i < this.rank_; ++i) {
            if (this.dimensions_[i] == null) continue;
            return true;
        }
        return false;
    }

    public NcDimension[] getFreeDimensions() {
        if (this.dimensions_ == null) {
            this.createDimensions();
        }
        NcDimension[] dims = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            dims[i] = this.dimensions_[i] == null ? null : this.dimensions_[i];
        }
        return this.dimensions_;
    }

    public int getDimensionId(NcDimension dim) {
        if (this.dimensions_ == null) {
            this.createDimensions();
        }
        if (dim == null) {
            throw new IllegalArgumentException("Dimension is null.");
        }
        for (int i = 0; i < this.rank_; ++i) {
            if (this.dimensions_[i] == null || this.dimensions_[i] != dim) continue;
            return i;
        }
        return -1;
    }

    public boolean isAveragingDimension(int dimIndex) {
        return false;
    }

    public String getUnits() {
        return NcArray.getUnits(this.varDS_);
    }

    public boolean hasBadValues() {
        return this.hasBad_;
    }

    public boolean isMissingOrInvalid(double value) {
        if (Double.isNaN(value)) {
            return true;
        }
        if (this.hasMissing_ && this.varDS_.isMissingValue(value)) {
            return true;
        }
        if (this.hasCorrectedFill_ && value == (double)this.correctedFillValue_) {
            return true;
        }
        if (this.hasFill_ && this.varDS_.isFillValue(value)) {
            return true;
        }
        if (this.hasInvalid_ && this.varDS_.isInvalidData(value)) {
            return value > this.validMax_ || value < this.validMin_;
        }
        return this.hasBad_ && this.varDS_.isMissing(value);
    }

    public double minimumValue() throws NcException {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.minimum_;
    }

    public double maximumValue() throws NcException {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.maximum_;
    }

    protected double[] getActualRange() {
        Array rarray;
        double[] rvalues;
        Attribute rangeA = this.varDS_.findAttribute("actual_range");
        if (rangeA == null) {
            return null;
        }
        if (rangeA.isArray() && (rvalues = (double[])(rarray = rangeA.getValues()).get1DJavaArray(Double.class)).length == 2) {
            return rvalues;
        }
        return null;
    }

    protected abstract void findExtrema();

    public int getSliceIndex(int dimNum) {
        if (dimNum < 0 || dimNum >= this.shape_.length) {
            throw new IllegalArgumentException("Invalid dimension ID");
        }
        return this.sIndex_[dimNum];
    }

    public void setSliceIndex(int dimNum, int index) {
        if (dimNum < 0 || dimNum >= this.shape_.length) {
            throw new IllegalArgumentException("Invalid dimension ID");
        }
        if (index < 0 && !this.isAveragingDimension(dimNum)) {
            throw new IllegalArgumentException("Slice index less than zero.");
        }
        this.needsSlice_ = true;
        this.needsExtrema_ = true;
        this.minimum_ = Double.NaN;
        this.maximum_ = Double.NaN;
        this.sIndex_[dimNum] = index;
    }

    public NcDataset getDataset() {
        return this.dataset_;
    }

    public String getName() {
        return this.varDS_.getShortName();
    }

    public String getLongName() {
        return NcVarUtilities.getLongName(this.varDS_);
    }

    public static String getUnits(VariableDS v) {
        if (v == null) {
            return null;
        }
        return NcVarUtilities.getUnits(v);
    }

    public Unit getUcarUnits() {
        return NcArray.getUcarUnits(this.varDS_);
    }

    public static Unit getUcarUnits(VariableDS v) {
        if (v == null) {
            return null;
        }
        String units = NcArray.getUnits(v);
        if (units == null) {
            return null;
        }
        if (unitFormat_ == null) {
            unitFormat_ = UnitFormatManager.instance();
        }
        try {
            return unitFormat_.parse(units);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public boolean isCompatible(NcArray vp) {
        if (vp == null) {
            throw new IllegalArgumentException("Null variable argument.");
        }
        return this.isCompatible(vp.getUcarUnits());
    }

    public boolean isCompatible(Unit u2) {
        Unit u1 = this.getUcarUnits();
        if (u1 == null && u2 == null) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return u2.isCompatible(u1);
    }

    public static String arrayString(Object aArray) {
        if (aArray == null) {
            return "";
        }
        StringBuffer result = new StringBuffer("[");
        int length = java.lang.reflect.Array.getLength(aArray);
        for (int i = 0; i < length; ++i) {
            Object o = java.lang.reflect.Array.get(aArray, i);
            if (o == null) {
                result.append(o);
            } else {
                result.append(o.toString());
            }
            if (i >= length - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public abstract NcGridder getGridder();
}

