/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.math;

public final class Geometry2D {
    private static final double TINY_VAL = 1.0E-10;

    public static boolean isPointInQuadrilateral(double x, double y, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (Geometry2D.isPointInTriangle(x, y, x1, y1, x2, y2, x3, y3)) {
            return true;
        }
        return Geometry2D.isPointInTriangle(x, y, x1, y1, x3, y3, x4, y4);
    }

    public static boolean isPointInTriangle(double x, double y, double x1, double y1, double x2, double y2, double x3, double y3) {
        double b = (x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1);
        double b1 = ((x2 - x) * (y3 - y) - (x3 - x) * (y2 - y)) / b;
        double b2 = ((x3 - x) * (y1 - y) - (x1 - x) * (y3 - y)) / b;
        double b3 = ((x1 - x) * (y2 - y) - (x2 - x) * (y1 - y)) / b;
        if (b1 > 0.0 && b2 > 0.0 && b3 > 0.0) {
            return true;
        }
        return Math.abs(b1) < 1.0E-10 || Math.abs(b2) < 1.0E-10 || Math.abs(b3) < 1.0E-10;
    }

    private Geometry2D() {
    }
}

