/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.gui;

import gov.nasa.giss.map.proj.ListParameter;
import gov.nasa.giss.map.proj.gui.ProjField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ProjListField
extends ProjField {
    private ListParameter parameter_;
    private JComboBox cbox_;

    public ProjListField(ListParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjListField(ListParameter parameter, Object value) {
        this(parameter, value, false);
    }

    public ProjListField(ListParameter parameter, Object value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getName() + ": ");
        nLabel.setOpaque(false);
        this.add(nLabel);
        this.cbox_ = new JComboBox<Object>(parameter.getChoices());
        this.cbox_.setOpaque(false);
        this.cbox_.setSelectedItem(value);
        this.add(this.cbox_);
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
        this.cbox_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                ProjListField.this.handleParam();
            }
        });
    }

    public void reset() {
        this.cbox_.setSelectedItem(this.parameter_.getDefault());
        this.handleParam();
    }

    public String getStringValue() {
        return this.getValue().toString();
    }

    public Object getValue() {
        return this.cbox_.getSelectedItem();
    }

    public void setValue(Object value) {
        this.cbox_.setSelectedItem(value);
        this.parameter_.setValue(value);
        super.fireParamAction();
    }

    public void setValue(String value) {
        int isize = this.cbox_.getItemCount();
        for (int i = 0; i < isize; ++i) {
            Object o = this.cbox_.getItemAt(i);
            if (!value.equals(o.toString())) continue;
            this.cbox_.setSelectedIndex(i);
            this.parameter_.setValue(o);
            break;
        }
        super.fireParamAction();
    }

    protected void handleParam() {
        this.parameter_.setValue(this.cbox_.getSelectedItem());
        super.fireParamAction();
    }
}

