/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.gui;

import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.gui.ProjField;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.TextUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ProjDoubleField
extends ProjField {
    private static final PrintfFormat NFORMAT = new PrintfFormat("%.4g");
    private DoubleParameter parameter_;
    private JTextField tf_;

    public ProjDoubleField(DoubleParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjDoubleField(DoubleParameter parameter, double value) {
        this(parameter, value, false);
    }

    public ProjDoubleField(DoubleParameter parameter, double value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getName() + ": ");
        nLabel.setOpaque(false);
        this.add(nLabel);
        this.tf_ = new JTextField(4);
        this.tf_.setHorizontalAlignment(4);
        this.setValue(value);
        this.add(this.tf_);
        String punits = this.parameter_.getUnits();
        if (punits != null && punits.length() > 0) {
            JLabel uLabel = new JLabel(punits);
            uLabel.setOpaque(false);
            this.add(uLabel);
        }
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
        this.tf_.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ProjDoubleField.this.handleParam();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.tf_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjDoubleField.this.handleParam();
            }
        });
    }

    public void reset() {
        this.tf_.setText(NFORMAT.sprintf(this.parameter_.getDefault()));
        this.handleParam();
    }

    public String getStringValue() {
        return NFORMAT.sprintf(this.getValue());
    }

    public double getValue() {
        try {
            return TextUtilities.parseDouble(this.tf_.getText());
        }
        catch (Exception exc) {
            return this.parameter_.getValue();
        }
    }

    public void setValue(double dd) {
        try {
            this.tf_.setText(NFORMAT.sprintf(dd));
            this.parameter_.setValue(dd);
        }
        catch (Exception exc) {
            System.out.println("WARNING: setValue : " + exc.toString());
            this.tf_.setText(NFORMAT.sprintf(this.parameter_.getValue()));
        }
        this.tf_.repaint();
        super.fireParamAction();
    }

    protected void handleParam() {
        try {
            double dd = TextUtilities.parseDouble(this.tf_.getText());
            this.parameter_.setValue(dd);
        }
        catch (Exception exc) {
            System.out.println("WARNING: " + exc.toString());
            this.tf_.setText(NFORMAT.sprintf(this.parameter_.getValue()));
            this.tf_.repaint();
        }
        super.fireParamAction();
    }
}

