/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.gui;

import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.gui.ProjField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

public class ProjBooleanField
extends ProjField {
    private BooleanParameter parameter_;
    private JCheckBox cbox_;

    public ProjBooleanField(BooleanParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjBooleanField(BooleanParameter parameter, boolean value) {
        this(parameter, value, false);
    }

    public ProjBooleanField(BooleanParameter parameter, boolean value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.cbox_ = new JCheckBox(parameter.getName(), value);
        this.cbox_.setOpaque(false);
        this.add(this.cbox_);
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
        this.cbox_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ProjBooleanField.this.handleParam();
            }
        });
    }

    public void reset() {
        this.setSelected(this.parameter_.getDefault());
        this.handleParam();
    }

    public String getStringValue() {
        return Boolean.toString(this.isSelected());
    }

    public boolean isSelected() {
        return this.cbox_.isSelected();
    }

    public void setSelected(boolean bb) {
        this.cbox_.setSelected(bb);
        this.parameter_.setSelected(bb);
        super.fireParamAction();
    }

    protected void handleParam() {
        this.parameter_.setSelected(this.cbox_.isSelected());
        super.fireParamAction();
    }
}

