/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Winkel2
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Winkel II";
    private static final double ONE_OVER_PI2 = 0.10132118364233778;
    private static final double COS_PHI1 = 0.6366197723675814;
    private static final double WIDTH_FACTOR = 2.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public Winkel2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Winkel2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Winkel2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.5707963267948966, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Winkel2.toRadians(lat);
        double x = 0.5 * this.lon2LambdaRad(lon) * (0.6366197723675814 + Math.sqrt(1.0 - 4.0 * phiRad * phiRad * 0.10132118364233778));
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * 2.0 * this.oneOverRS_ / (0.6366197723675814 + Math.sqrt(1.0 - 4.0 * phiRad * phiRad * 0.10132118364233778));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Winkel2.toDegrees(phiRad);
        double lambda = Winkel2.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double twoOverRS = 2.0 * this.oneOverRS_;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Winkel2.toDegrees(phiRad);
            double xFactor = twoOverRS / (0.6366197723675814 + Math.sqrt(1.0 - 4.0 * phiRad * phiRad * 0.10132118364233778));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Winkel2.toDegrees(lambdaRad), phi);
            }
        }
    }
}

