/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Winkel1
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Winkel I";
    private static final double DEFAULT_COS_PHI1 = 0.6366197723675814;
    private static final double DEFAULT_PHI1 = Math.acos(0.6366197723675814) * 57.29577951308232;
    private static final double WIDTH_FACTOR = 2.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double cosPhi1_ = 0.6366197723675814;

    public Winkel1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Winkel1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Winkel1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.5707963267948966, 1.5707963267948966);
        this.addParameter(new DoubleParameter("Std. Parallel", "\u00b0", DEFAULT_PHI1, -90.0, 90.0, true, true));
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(((DoubleParameter)p).getValue());
    }

    public void setStandardParallel(double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Standard latitude must be between -90 and 90.");
        }
        this.cosPhi1_ = Math.cos(Winkel1.toRadians(lat));
        this.autoscale();
    }

    protected void prepareScaling() {
        this.setSizeFactors(1.5707963267948966 * (this.cosPhi1_ + 1.0), 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Winkel1.toRadians(lat);
        double x = 0.5 * this.lon2LambdaRad(lon) * (this.cosPhi1_ + Math.cos(phiRad));
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * 2.0 * this.oneOverRS_ / (this.cosPhi1_ + Math.cos(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Winkel1.toDegrees(phiRad);
        double lambda = Winkel1.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Winkel1.toDegrees(phiRad);
            double xFactor = 2.0 * this.oneOverRS_ / (this.cosPhi1_ + Math.cos(phiRad));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Winkel1.toDegrees(lambdaRad), phi);
            }
        }
    }
}

