/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ConcavePoleProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner9
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Wagner IX";
    public static final int PROPERTIES = 16;
    private static final double TERMK = Math.sqrt(2.8);
    private static final double TERMM = 0.7777777777777778;
    private static final double TERMN = 0.2777777777777778;
    private static final double ONE_OVER_M = 1.2857142857142856;
    private static final double ONE_OVER_N = 3.5999999999999996;
    private static final double CSUBX = TERMK / Math.sqrt(0.2160493827160494);
    private static final double CSUBY = 1.0 / (TERMK * Math.sqrt(0.2160493827160494));
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double ONE_OVER_CSUBY = 1.0 / CSUBY;
    private static final double WIDTH_FACTOR = CSUBX * 0.2777777777777778 * Math.PI;
    private static final double FOO = Math.cos(1.2217304763960306) * Math.cos(0.8726646259971648);
    private static final double HEIGHT_FACTOR = CSUBY * Math.acos(FOO) * Math.sin(1.2217304763960306) / Math.sqrt(1.0 - FOO * FOO);

    public Wagner9(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner9(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner9(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 0.0) {
            double x = this.lon2LambdaRad(lon);
            return new Point2D.Double((double)this.outCenterX_ + x * this.rS_, this.outCenterY_);
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = Wagner9.toRadians(lat);
        if (lambdaRad == 0.0) {
            double y = phiRad;
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - y * this.rS_);
        }
        double d = Math.acos(Math.cos(0.7777777777777778 * phiRad) * Math.cos(0.2777777777777778 * lambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) > 1.0E-5) {
            double cosA = Math.sin(0.7777777777777778 * phiRad) / Math.sin(d);
            x = CSUBX * d * Math.sqrt(1.0 - cosA * cosA);
            y = CSUBY * d * cosA;
            if (lambdaRad < 0.0) {
                x *= -1.0;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double d = Math.hypot(x * ONE_OVER_CSUBX, y * ONE_OVER_CSUBY) * this.oneOverRS_;
        if (d > 1.0E-5) {
            double yOverRS = y * this.oneOverRS_;
            double phiTerm = yOverRS * Math.sin(d) / (d * CSUBY);
            if (phiTerm > 1.0) {
                return null;
            }
            phiRad = Math.asin(phiTerm) * 1.2857142857142856;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            double d2 = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : Math.acos(Math.cos(d) / Math.cos(0.7777777777777778 * phiRad)) * 3.5999999999999996;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        } else {
            phiRad = 0.0;
            lambdaRad = 0.0;
        }
        double phi = Wagner9.toDegrees(phiRad);
        double lambda = Wagner9.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverCy = y * ONE_OVER_CSUBY;
            double yOverRS = y * this.oneOverRS_;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                double d = Math.hypot(x * ONE_OVER_CSUBX, yOverCy) * this.oneOverRS_;
                if (d > 1.0E-5) {
                    double phiTerm = yOverRS * Math.sin(d) / (d * CSUBY);
                    if (phiTerm > 1.0 || (phiRad = Math.asin(phiTerm) * 1.2857142857142856) > 1.5707963267948966) continue;
                    if (phiRad < 1.5707963267948966) {
                        lambdaRad = Math.acos(Math.cos(d) / Math.cos(0.7777777777777778 * phiRad)) * 3.5999999999999996;
                        if (lambdaRad > Math.PI) {
                            continue block0;
                        }
                    } else {
                        lambdaRad = 0.0;
                    }
                } else {
                    phiRad = 0.0;
                    lambdaRad = 0.0;
                }
                this.setQSymmetricPoints(ix, iy, Wagner9.toDegrees(lambdaRad), Wagner9.toDegrees(phiRad));
            }
        }
    }
}

