/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner6
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Wagner VI";
    private static final double CSUBX = 1.0;
    private static final double ONE_OVER_CSUBX = 1.0;
    private static final double CSUBY = 1.0;
    private static final double ONE_OVER_CSUBY = 1.0;
    private static final double TERMA = 0.0;
    private static final double TERMB = 3.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ONE_OVER_PI = 0.3183098861837907;

    public Wagner6(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner6(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner6(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Wagner6.toRadians(lat);
        double phiOverPi = phiRad * 0.3183098861837907;
        double x = 1.0 * this.lon2LambdaRad(lon) * (0.0 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
        double y = 1.0 * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_ * 1.0;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phiOverPi = phiRad * 0.3183098861837907;
        double lambdaRad = x * this.oneOverRS_ * 1.0 / (0.0 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Wagner6.toDegrees(phiRad);
        double lambda = Wagner6.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double oneOverRSCx = this.oneOverRS_ * 1.0;
        double oneOverRSCy = this.oneOverRS_ * 1.0;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * oneOverRSCy) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner6.toDegrees(phiRad);
            double phiOverPi = phiRad * 0.3183098861837907;
            double xFactor = oneOverRSCx / (0.0 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner6.toDegrees(lambdaRad), phi);
            }
        }
    }
}

