/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner4
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Wagner IV";
    private static final double TERMP = 1.0471975511965976;
    private static final double CSUBP = 2.0943951023931953 + Math.sin(2.0943951023931953);
    private static final double ONE_OVER_CSUBP = 1.0 / CSUBP;
    private static final double TERMR = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) * ONE_OVER_CSUBP);
    private static final double CSUBX = TERMR * 2.0 / Math.PI;
    private static final double CSUBY = TERMR / Math.sin(1.0471975511965976);
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double ONE_OVER_CSUBY = 1.0 / CSUBY;
    private static final double WIDTH_FACTOR = CSUBX * Math.PI;
    private static final double HEIGHT_FACTOR = CSUBY * Math.sin(1.0471975511965976);

    public Wagner4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner4(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiFactor = CSUBP * Math.sin(Wagner4.toRadians(lat));
        double thetaRad = Wagner4.toRadians(lat);
        for (int iter = 0; iter < 25; ++iter) {
            double func = thetaRad + Math.sin(thetaRad) - phiFactor;
            double dfunc = 1.0 + Math.cos(thetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = CSUBX * this.lon2LambdaRad(lon) * Math.cos(0.5 * thetaRad);
        double y = CSUBY * Math.sin(0.5 * thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double halfThetaRad = Math.asin(y * this.oneOverRS_ * ONE_OVER_CSUBY);
        double thetaRad = 2.0 * halfThetaRad;
        double phiRad = Math.asin((thetaRad + Math.sin(thetaRad)) * ONE_OVER_CSUBP);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ * ONE_OVER_CSUBX / Math.cos(halfThetaRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Wagner4.toDegrees(phiRad);
        double lambda = Wagner4.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double halfThetaRad;
        double thetaRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(((thetaRad = 2.0 * (halfThetaRad = Math.asin((y = (double)iy + 0.5) * this.oneOverRS_ * ONE_OVER_CSUBY))) + Math.sin(thetaRad)) * ONE_OVER_CSUBP)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner4.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ * ONE_OVER_CSUBX / Math.cos(halfThetaRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner4.toDegrees(lambdaRad), phi);
            }
        }
    }
}

