/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner3
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Wagner III";
    private static final double DEFAULT_PHITS = 0.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double phiTSFactor_;

    public Wagner3(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(new DoubleParameter("Std. Parallel", "\u00b0", 0.0, 0.0, 90.0, true, false));
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(((DoubleParameter)p).getValue());
    }

    public void setStandardParallel(double lat) {
        double phiTSRad = Wagner3.toRadians(lat);
        double cosPhiTS = Math.cos(phiTSRad);
        double cos2PhiTSOver3 = Math.cos(phiTSRad * 2.0 / 3.0);
        this.phiTSFactor_ = cosPhiTS / cos2PhiTSOver3;
        this.autoscale();
    }

    protected void prepareScaling() {
        this.setSizeFactors(Math.PI * this.phiTSFactor_, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Wagner3.toRadians(lat);
        double x = this.lon2LambdaRad(lon) * this.phiTSFactor_ * Math.cos(phiRad * 2.0 / 3.0);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / (this.phiTSFactor_ * Math.cos(phiRad * 2.0 / 3.0));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Wagner3.toDegrees(phiRad);
        double lambda = Wagner3.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner3.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / (this.phiTSFactor_ * Math.cos(phiRad * 2.0 / 3.0));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner3.toDegrees(lambdaRad), phi);
            }
        }
    }
}

