/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner2
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Wagner II";
    private static final double TERMA = 0.92483;
    private static final double TERMB = 1.38725;
    private static final double TERMC = 0.88022;
    private static final double TERMD = 0.8855;
    private static final double ONE_OVER_TERMB = 0.7208506037123805;
    private static final double ONE_OVER_TERMD = 1.129305477131564;
    private static final double WIDTH_FACTOR = 2.9054391338194483;
    private static final double HEIGHT_FACTOR = 1.38725 * Math.asin(0.88022 * Math.sin(1.3909401473768808));

    public Wagner2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.9054391338194483, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Wagner2.toRadians(lat);
        double thetaRad = Math.asin(0.88022 * Math.sin(0.8855 * phiRad));
        double x = 0.92483 * this.lon2LambdaRad(lon) * Math.cos(thetaRad);
        double y = 1.38725 * thetaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = y * this.oneOverRS_ * 0.7208506037123805;
        double phiRad = Math.asin(Math.sin(thetaRad) / 0.88022) * 1.129305477131564;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / (0.92483 * Math.cos(thetaRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Wagner2.toDegrees(phiRad);
        double lambda = Wagner2.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(Math.sin(thetaRad = this.oneOverRS_ * (y = (double)iy + 0.5) * 0.7208506037123805) / 0.88022) * 1.129305477131564) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner2.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / (0.92483 * Math.cos(thetaRad));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner2.toDegrees(lambdaRad), phi);
            }
        }
    }
}

