/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner1
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Wagner I";
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double FOURTHROOTOF3 = Math.sqrt(SQRT3);
    private static final double TERMA = 2.0 * FOURTHROOTOF3 / 3.0;
    private static final double TERMB = 0.5 * SQRT3;
    private static final double ONE_OVER_B = 1.0 / TERMB;
    private static final double A_TIMES_B = TERMA * TERMB;
    private static final double ONE_OVER_AB = 1.0 / A_TIMES_B;
    private static final double WIDTH_FACTOR = TERMA * Math.PI;
    private static final double HEIGHT_FACTOR = Math.asin(TERMB) * ONE_OVER_AB;

    public Wagner1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double thetaRad = Math.asin(TERMB * Math.sin(Wagner1.toRadians(lat)));
        double x = TERMA * this.lon2LambdaRad(lon) * Math.cos(thetaRad);
        double y = thetaRad * ONE_OVER_AB;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = y * this.oneOverRS_ * A_TIMES_B;
        double phiRad = Math.asin(Math.sin(thetaRad) * ONE_OVER_B);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / (TERMA * Math.cos(thetaRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Wagner1.toDegrees(phiRad);
        double lambda = Wagner1.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(Math.sin(thetaRad = (y = (double)iy + 0.5) * this.oneOverRS_ * A_TIMES_B) * ONE_OVER_B)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner1.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / (TERMA * Math.cos(thetaRad));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner1.toDegrees(lambdaRad), phi);
            }
        }
    }
}

