/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class VerticalPerspective
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Vertical Perspective";
    public static final int PROPERTIES = 131104;
    private static final double DEFAULT_R = 6.61;
    private double pFactor_;
    private double oneOverP_;
    private double pSquare_;
    private double pMinus1_;
    private double rhoBorder2_;

    public VerticalPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public VerticalPerspective(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public VerticalPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131104, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new DoubleParameter("Center Distance", "Radii (R>1)", 6.61, 1.0, Double.POSITIVE_INFINITY, false, true));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setCenterDistance(((DoubleParameter)p).getValue());
    }

    public void setCenterDistance(double r) {
        this.pFactor_ = r;
        this.pSquare_ = this.pFactor_ * this.pFactor_;
        this.pMinus1_ = this.pFactor_ - 1.0;
        this.autoscale();
    }

    protected void prepareScaling() {
        this.oneOverP_ = 1.0 / this.pFactor_;
        double rhoMaxOverR = Math.sqrt((this.pFactor_ - 1.0) / (this.pFactor_ + 1.0));
        this.setSizeFactors(rhoMaxOverR, rhoMaxOverR);
    }

    protected void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = VerticalPerspective.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ < this.oneOverP_) {
            return null;
        }
        double k = this.pMinus1_ / (this.pFactor_ - cosZ);
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double capKP;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double y2 = y * y;
        double x2 = x * x;
        double rho2 = x * x + y2;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double sqrtCapK = rho * this.oneOverRS_ / this.pMinus1_;
        double capK = sqrtCapK * sqrtCapK;
        double capKPlus1 = capK + 1.0;
        double sqrtTerm = capKPlus1 - (capKP = capK * this.pFactor_) * this.pFactor_;
        double cosZ = sqrtTerm > 0.0 ? (capKP + Math.sqrt(capKPlus1 - capKP * this.pFactor_)) / capKPlus1 : capKP / capKPlus1;
        double sinZ = Math.sqrt(1.0 - cosZ * cosZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phi = VerticalPerspective.toDegrees(phiRad);
        double lambda = VerticalPerspective.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        if (this.pMinus1_ <= 0.0) {
            return;
        }
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > this.rhoBorder2_) continue;
                double rho = Math.sqrt(rho2);
                double sqrtCapK = rho * this.oneOverRS_ / this.pMinus1_;
                double capK = sqrtCapK * sqrtCapK;
                double capKPlus1 = capK + 1.0;
                double capKP = capK * this.pFactor_;
                double cosZ = (capKP + Math.sqrt(capKPlus1 - capKP * this.pFactor_)) / capKPlus1;
                double sinZ = Math.sqrt(1.0 - cosZ * cosZ);
                double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
                double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
                this.setBiSymmetricPoints(ix, iy, VerticalPerspective.toDegrees(lambdaRad), VerticalPerspective.toDegrees(phiRad));
            }
        }
    }
}

