/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.EllipseProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class VanDerGrinten1
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Van Der Grinten I";
    public static final int PROPERTIES = 16;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.PI;
    private static final double ONE_OVER_PI = 0.3183098861837907;
    private static final double PI_OVER_3 = 1.0471975511965976;

    public VanDerGrinten1(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public VanDerGrinten1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, Math.PI, Math.PI);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        if (lat == 0.0) {
            double x = lambdaRad;
            double y = 0.0;
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        if (lat == 90.0 || lat == -90.0) {
            double x = 0.0;
            double y = Math.PI;
            if (lat < 0.0) {
                y = -y;
            }
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        double b = Math.abs(VanDerGrinten1.toRadians(lat) / 1.5707963267948966);
        double c = Math.sqrt(1.0 - b * b);
        if (lambdaRad == 0.0) {
            double x = 0.0;
            double y = Math.PI * b / (1.0 + c);
            if (lat < 0.0) {
                y = -y;
            }
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        double a = 0.5 * Math.abs(Math.PI / lambdaRad - lambdaRad / Math.PI);
        double a2 = a * a;
        double g = c / (b + c - 1.0);
        double p = g * (2.0 / b - 1.0);
        double p2 = p * p;
        double q = a2 + g;
        double s = p2 + a2;
        double t = g - p2;
        double x = Math.PI * (a * t + Math.sqrt(a2 * t * t - s * (g * g - p2))) / s;
        double y = Math.PI * (p * q - a * Math.sqrt((a2 + 1.0) * s - q * q)) / s;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xa = Math.abs(x);
        double ya = Math.abs(y);
        double[] llRad = this.transformXaYa2LL(xa, y);
        if (llRad == null) {
            return null;
        }
        double lambda = VanDerGrinten1.toDegrees(llRad[0]);
        double phi = VanDerGrinten1.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double oneOverPiRS = this.oneOverRS_ * 0.3183098861837907;
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double[] llRad;
            double y = (double)iy + 0.5;
            for (int ix = 0; ix < this.xMax_ && (llRad = this.transformXaYa2LL(x = (double)ix + 0.5, y)) != null; ++ix) {
                this.setQSymmetricPoints(ix, iy, VanDerGrinten1.toDegrees(llRad[0]), VanDerGrinten1.toDegrees(llRad[1]));
            }
        }
    }

    private double[] transformXaYa2LL(double x, double y) {
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double oneOverPiRS = this.oneOverRS_ * 0.3183098861837907;
        double y2 = y * y;
        double x2 = x * x;
        if (y2 + x * x > rhoMax2) {
            return null;
        }
        double capY = y * oneOverPiRS;
        double capY2 = capY * capY;
        double capX = x * oneOverPiRS;
        double capX2 = capX * capX;
        double capX2pY2 = capX2 + capY2;
        double c1 = -Math.abs(capY) * (1.0 + capX2pY2);
        double c2 = c1 - 2.0 * capY2 + capX2;
        double c3 = -2.0 * c1 + 1.0 + 2.0 * capY2 + capX2pY2 * capX2pY2;
        double d = capY2 / c3 + (2.0 * c2 * c2 * c2 / c3 - 9.0 * c1 * c2) / (27.0 * c3 * c3);
        double a1 = (c1 - c2 * c2 / (3.0 * c3)) / c3;
        double m1 = 2.0 * Math.sqrt(-a1 / 3.0);
        double theta1 = Math.acos(3.0 * d / (a1 * m1)) / 3.0;
        double phiRad = Math.PI * (-m1 * Math.cos(theta1 + 1.0471975511965976) - c2 / (3.0 * c3));
        double lambdaRad = 0.0;
        if (capX != 0.0) {
            lambdaRad = 1.5707963267948966 * (capX2pY2 - 1.0 + Math.sqrt(1.0 + 2.0 * (capX2 - capY2) + capX2pY2 * capX2pY2)) / capX;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

