/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class UrmayevSinusoidal
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Urmayev Sinusoidal";
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double FOURTHROOTOF3 = Math.sqrt(SQRT3);
    private static final double DEFAULTB = 0.5 * SQRT3;
    private static final double ONE_OVER_DEFAULTB = 1.0 / DEFAULTB;
    private static final double CONST_A = 2.0 * FOURTHROOTOF3 / 3.0;
    private static final double ONE_OVER_A = 1.0 / CONST_A;
    private static final double WIDTH_FACTOR = CONST_A * Math.PI;
    private static final double HEIGHT_FACTOR = Math.asin(DEFAULTB) / (CONST_A * DEFAULTB);
    private double termB_ = DEFAULTB;
    private double oneOverB_ = 1.0;
    private double aTimesB_ = 1.0;
    private double oneOverAB_ = 1.0;
    private double aOverRS_ = 1.0;
    private double aBOverRS_ = 1.0;
    private double oneOverARS_ = 1.0;

    public UrmayevSinusoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public UrmayevSinusoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public UrmayevSinusoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.addParameter(new DoubleParameter("Pole-Line Param.", "(0\u2264b\u22641)", 0.75, 0.0, 1.0, true, true));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setPoleLineParam(((DoubleParameter)p).getValue());
    }

    public void setPoleLineParam(double b) {
        this.termB_ = b;
        this.aTimesB_ = CONST_A * this.termB_;
        this.oneOverB_ = this.termB_ > 0.0 ? 1.0 / this.termB_ : 1.0E10;
        this.oneOverAB_ = this.termB_ > 0.0 ? 1.0 / this.aTimesB_ : 1.0E10;
        this.autoscale();
    }

    protected void prepareScaling() {
        double yMaxOverR = this.termB_ > 0.0 ? Math.asin(this.termB_) * this.oneOverAB_ : ONE_OVER_A;
        this.setSizeFactors(WIDTH_FACTOR, yMaxOverR);
    }

    protected void finishScaling() {
        this.aOverRS_ = CONST_A * this.oneOverRS_;
        this.aBOverRS_ = this.aTimesB_ * this.oneOverRS_;
        this.oneOverARS_ = ONE_OVER_A * this.oneOverRS_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = UrmayevSinusoidal.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double lambdaRad = this.lon2LambdaRad(lon);
        if (this.termB_ == 0.0) {
            x = CONST_A * lambdaRad;
            y = ONE_OVER_A * sinPhi;
        } else if (this.termB_ == 1.0) {
            x = CONST_A * lambdaRad * Math.cos(phiRad);
            y = ONE_OVER_A * phiRad;
        } else {
            double thetaRad = Math.asin(this.termB_ * sinPhi);
            x = CONST_A * lambdaRad * Math.cos(thetaRad);
            y = this.oneOverAB_ * thetaRad;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (this.termB_ == 0.0) {
            phiRad = Math.asin(y * this.aOverRS_);
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            lambdaRad = x * this.oneOverARS_;
        } else if (this.termB_ == 1.0) {
            phiRad = y * this.aBOverRS_;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            if (Math.abs(phiRad) == 1.5707963267948966) {
                if (x != 0.0) return null;
                lambdaRad = 0.0;
            } else {
                lambdaRad = x * this.oneOverARS_ / Math.cos(phiRad);
            }
        } else {
            double thetaRad = y * this.aBOverRS_;
            phiRad = Math.asin(Math.sin(thetaRad) * this.oneOverB_);
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            lambdaRad = x * this.oneOverARS_ / Math.cos(thetaRad);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = UrmayevSinusoidal.toDegrees(phiRad);
        double lambda = UrmayevSinusoidal.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double lambdaRad;
            double xFactor;
            double phiRad;
            double y = (double)iy + 0.5;
            if (this.termB_ == 0.0) {
                phiRad = Math.asin(y * this.aOverRS_);
                xFactor = this.oneOverARS_;
            } else if (this.termB_ == 1.0) {
                phiRad = y * this.aBOverRS_;
                if (phiRad > 1.5707963267948966) break;
                xFactor = phiRad == 1.5707963267948966 ? 0.0 : this.oneOverARS_ / Math.cos(phiRad);
            } else {
                double thetaRad = y * this.aBOverRS_;
                phiRad = Math.asin(Math.sin(thetaRad) * this.oneOverB_);
                if (phiRad > 1.5707963267948966) break;
                xFactor = this.oneOverARS_ / Math.cos(thetaRad);
            }
            double phi = UrmayevSinusoidal.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, UrmayevSinusoidal.toDegrees(lambdaRad), phi);
            }
        }
    }
}

