/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class ToblerG1
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Tobler G1";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.sqrt(1.5707963267948966);

    public ToblerG1(int width, int height) {
        this(width, height, 0, 0);
    }

    public ToblerG1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ToblerG1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = ToblerG1.toRadians(lat);
        if (lat == 0.0) {
            y = 0.0;
            x = lambdaRad;
        } else {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            y = Math.sqrt(phiRad * sinPhi);
            if (lat < 0.0) {
                y = -y;
            }
            x = 2.0 * cosPhi * y * lambdaRad / (sinPhi + phiRad * cosPhi);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double sqrtPhiSinPhi;
        double cosPhi;
        double sinPhi;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double absOverRS = Math.abs(yOverRS);
        if (y == 0.0) {
            double phi = 0.0;
            double lambda = ToblerG1.toDegrees(x * this.oneOverRS_);
            return new PointLL(this.lambdaC_ + lambda, phi);
        }
        double absPhiRad = 1.5707963267948966 * Math.abs(y) / this.ymRS_;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            sinPhi = Math.sin(absPhiRad);
            cosPhi = Math.cos(absPhiRad);
            sqrtPhiSinPhi = Math.sqrt(absPhiRad * sinPhi);
            double func = sqrtPhiSinPhi - absOverRS;
            double dfunc = 0.5 / sqrtPhiSinPhi * (sinPhi + absPhiRad * cosPhi);
            double dphiRad = -func / dfunc;
            absPhiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
            ++iters;
        }
        if (Math.abs(lambdaRad = 0.5 * x * this.oneOverRS_ * ((sinPhi = Math.sin(absPhiRad)) + absPhiRad * (cosPhi = Math.cos(absPhiRad))) / (cosPhi * (sqrtPhiSinPhi = Math.sqrt(absPhiRad * sinPhi)))) > Math.PI) {
            return null;
        }
        double phiRad = y > 0.0 ? absPhiRad : -absPhiRad;
        double phi = ToblerG1.toDegrees(phiRad);
        double lambda = ToblerG1.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
            double x;
            double lambdaRad;
            double sqrtPhiSinPhi;
            double cosPhi;
            double sinPhi;
            double yOverRS = y * this.oneOverRS_;
            phiRad += 1.0E-5;
            int iters = 0;
            for (int iter = 0; iter < 25; ++iter) {
                sinPhi = Math.sin(phiRad);
                cosPhi = Math.cos(phiRad);
                sqrtPhiSinPhi = Math.sqrt(phiRad * sinPhi);
                double func = sqrtPhiSinPhi - yOverRS;
                double dfunc = 0.5 / sqrtPhiSinPhi * (sinPhi + phiRad * cosPhi);
                double dphiRad = -func / dfunc;
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
                ++iters;
            }
            if (phiRad > 1.5707963267948966) break;
            sinPhi = Math.sin(phiRad);
            cosPhi = Math.cos(phiRad);
            sqrtPhiSinPhi = Math.sqrt(phiRad * sinPhi);
            double phi = ToblerG1.toDegrees(phiRad);
            double xfactor = 0.5 * this.oneOverRS_ * (sinPhi + phiRad * cosPhi) / (cosPhi * sqrtPhiSinPhi);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xfactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, ToblerG1.toDegrees(lambdaRad), phi);
            }
        }
    }
}

