/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class TimesAtlas
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Times Atlas";
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double TERM2 = 1.7071067811865475;
    private static final double TERM3 = 0.585786437626905;
    private static final double WIDTH_FACTOR = 2.33992104024675;
    private static final double HEIGHT_FACTOR = 1.7071067811865475 * Math.tan(0.7853981633974483);

    public TimesAtlas(int width, int height) {
        this(width, height, 0, 0);
    }

    public TimesAtlas(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public TimesAtlas(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.33992104024675, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = TimesAtlas.toRadians(lat);
        double tanHalfPhi = Math.tan(0.5 * phiRad);
        double sinTerm = Math.sin(0.7853981633974483 * tanHalfPhi);
        double x = this.lon2LambdaRad(lon) * 0.74 * Math.sqrt(1.0 - 0.5 * tanHalfPhi * tanHalfPhi);
        double y = 1.7071067811865475 * tanHalfPhi;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.oneOverRS_ * 0.585786437626905);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double tanHalfPhi = Math.tan(0.5 * phiRad);
        double sinTerm = Math.sin(0.7853981633974483 * tanHalfPhi);
        double lambdaRad = x * this.oneOverRS_ / (0.74 * Math.sqrt(1.0 - 0.5 * tanHalfPhi * tanHalfPhi));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = TimesAtlas.toDegrees(phiRad);
        double lambda = TimesAtlas.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.oneOverRS_ * 0.585786437626905)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = TimesAtlas.toDegrees(phiRad);
            double tanHalfPhi = Math.tan(0.5 * phiRad);
            double sinTerm = Math.sin(0.7853981633974483 * tanHalfPhi);
            double xFactor = this.oneOverRS_ / (0.74 * Math.sqrt(1.0 - 0.5 * tanHalfPhi * tanHalfPhi));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, TimesAtlas.toDegrees(lambdaRad), phi);
            }
        }
    }
}

