/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Sinusoidal
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Sinusoidal";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public Sinusoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public Sinusoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Sinusoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 524292, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Sinusoidal.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double y = phiRad;
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon) * cosPhi;
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = Sinusoidal.normalizeLon180(lon) - clon;
            if (Sinusoidal.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon);
            x = cx + Sinusoidal.toRadians(dlon) * cosPhi;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosPhi = Math.cos(phiRad);
        double xFactor = cosPhi == 0.0 ? 0.0 : this.oneOverRS_ / cosPhi;
        double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Sinusoidal.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double phiRad = y * this.oneOverRS_;
            if (phiRad < -1.5707963267948966) continue;
            if (phiRad > 1.5707963267948966) break;
            double phi = Sinusoidal.toDegrees(phiRad);
            double cosPhi = Math.cos(phiRad);
            double xFactor = cosPhi == 0.0 ? 0.0 : this.oneOverRS_ / cosPhi;
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

