/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Robinson
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Robinson";
    private static final double A0 = 0.8507;
    private static final double A1 = 0.9642;
    private static final double A2 = -0.145;
    private static final double A3 = -0.0013;
    private static final double A4 = -0.0104;
    private static final double A5 = -0.0129;
    private static final double WIDTH_FACTOR = 2.672552870408837;
    private static final double HEIGHT_FACTOR = 1.3861591129060238;

    public Robinson(int width, int height) {
        this(width, height, 0, 0);
    }

    public Robinson(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Robinson(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.672552870408837, 1.3861591129060238);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = Robinson.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * (0.8507 + -0.145 * phiRad2 + -0.0104 * phiRad2 * phiRad2);
        double y = phiRad * (0.9642 + -0.0013 * phiRad2 + -0.0129 * phiRad2 * phiRad2);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad2;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            phiRad2 = phiRad * phiRad;
            double a3phiRad2 = -0.0013 * phiRad2;
            double a5phiRad4 = -0.0129 * phiRad2 * phiRad2;
            double dphiRad = -(phiRad * (0.9642 + a3phiRad2 + a5phiRad4) - yOverRS) / (0.9642 + 3.0 * a3phiRad2 + 5.0 * a5phiRad4);
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
            ++iters;
        }
        if (iters >= 25) {
            return null;
        }
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        phiRad2 = phiRad * phiRad;
        double lambdaRad = x * this.oneOverRS_ / (0.8507 + phiRad2 * (-0.145 + -0.0104 * phiRad2));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Robinson.toDegrees(phiRad);
        double lambda = Robinson.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double lambdaRad;
            double phiRad2;
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            phiRad += 1.0E-5;
            int iters = 0;
            for (int iter = 0; iter < 25; ++iter) {
                phiRad2 = phiRad * phiRad;
                double a3phiRad2 = -0.0013 * phiRad2;
                double a5phiRad4 = -0.0129 * phiRad2 * phiRad2;
                double dphiRad = -(phiRad * (0.9642 + a3phiRad2 + a5phiRad4) - yOverRS) / (0.9642 + 3.0 * a3phiRad2 + 5.0 * a5phiRad4);
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
                ++iters;
            }
            if (iters >= 25) break;
            double phi = Robinson.toDegrees(phiRad);
            phiRad2 = phiRad * phiRad;
            double xFactor = this.oneOverRS_ / (0.8507 + phiRad2 * (-0.145 + -0.0104 * phiRad2));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                double lambda = Robinson.toDegrees(lambdaRad);
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
    }
}

