/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class RaiszHalfEllipsoidal
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Raisz Half Ellipsoidal";
    public static final int PROPERTIES = 128;
    private static final double DEFAULT_TILT = 20.0;
    private static final double MAX_TILT = 90.0;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 1.0;
    private double tilt_;
    private double cosTilt_;
    private double sinTilt_;
    private double tanTilt_;
    private double latMin_;
    private double latMax_;
    private double yShift_;
    private double yMin_;
    private double yMax_;
    private Bezier[] bordersCurves_;

    public RaiszHalfEllipsoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public RaiszHalfEllipsoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public RaiszHalfEllipsoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 128, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(new DoubleParameter("Tilt Angle", "\u00b0", 20.0, -90.0, 90.0));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setTiltAngle(((DoubleParameter)p).getValue());
    }

    public void setTiltAngle(double tilt) {
        this.tilt_ = tilt;
        double tiltRad = this.tilt_ * (Math.PI / 180);
        this.cosTilt_ = Math.cos(tiltRad);
        this.sinTilt_ = Math.sin(tiltRad);
        this.tanTilt_ = Math.tan(tiltRad);
        this.autoscale();
    }

    protected void prepareScaling() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            this.setSizeFactors(2.0, this.cosTilt_);
        } else {
            double y1 = this.tilt_ > 0.0 ? this.cosTilt_ : -this.cosTilt_;
            double abstan = Math.abs(Math.tan(this.tilt_ * (Math.PI / 180)));
            double phisx = -Math.atan(0.5 / abstan);
            double cos2T = Math.cos(2.0 * this.tilt_ * (Math.PI / 180));
            double squCotT = (1.0 + cos2T) / (1.0 - cos2T);
            double y2 = -this.sinTilt_ * Math.sqrt(squCotT + 4.0);
            this.setSizeFactors(2.0, 0.5 * Math.abs(y1 - y2));
        }
    }

    protected void finishScaling() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            this.yShift_ = 0.0;
        } else {
            double y1 = this.tilt_ > 0.0 ? this.cosTilt_ : -this.cosTilt_;
            double abstan = Math.abs(Math.tan(this.tilt_ * (Math.PI / 180)));
            double phisx = -Math.atan(0.5 / abstan);
            double cos2T = Math.cos(2.0 * this.tilt_ * (Math.PI / 180));
            double squCotT = (1.0 + cos2T) / (1.0 - cos2T);
            double y2 = -this.sinTilt_ * Math.sqrt(squCotT + 4.0);
            this.yShift_ = -0.5 * (y1 + y2);
        }
        this.latMin_ = this.tilt_ > 0.0 ? this.findLatLimit(0.0) + 0.01 : -90.0;
        this.latMax_ = this.tilt_ < 0.0 ? this.findLatLimit(0.0) - 0.01 : 90.0;
        this.yMin_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMin_).y;
        this.yMax_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMax_).y;
        this.yMin_ = -(this.yMin_ - (double)this.outCenterY_);
        this.yMax_ = -(this.yMax_ - (double)this.outCenterY_);
        this.bordersCurves_ = null;
    }

    protected void drawBorderLines(Graphics2D g2d) {
        if (this.bordersCurves_ == null) {
            this.bordersCurves_ = this.makeBorders();
        }
        for (Bezier curve : this.bordersCurves_) {
            if (curve == null) continue;
            curve.paint(g2d);
        }
    }

    private Bezier[] makeBorders() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            return this.makeBorders0();
        }
        Vector<Point2D.Double> vector1 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector2 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector3 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector4 = new Vector<Point2D.Double>(100);
        int numPt = 90;
        double numPtFact = 2.0;
        double edgeLon = this.lambdaC_ + 180.0;
        Point2D.Double lastDot = null;
        for (int j = 0; j <= 90; ++j) {
            Point2D.Double dot;
            double lat = 90.0 - 2.0 * (double)j;
            if (this.tilt_ < 0.0) {
                lat *= -1.0;
            }
            if ((dot = this.transformLL2XY(edgeLon - 0.05, lat)) == null) break;
            vector1.add(new Point2D.Double(dot.x, dot.y));
            vector2.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            lastDot = dot;
        }
        if (lastDot != null) {
            vector3.add(new Point2D.Double(lastDot.x, lastDot.y));
            vector4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - lastDot.x, lastDot.y));
            double subtract = 0.0;
            while (subtract < 180.0) {
                subtract = subtract < 0.75 && this.tilt_ < 0.5 ? (subtract += 0.05) : (subtract < 5.0 ? (subtract += 0.5) : (subtract < 30.0 ? (subtract += 1.0) : (subtract < 60.0 ? (subtract += 2.0) : (subtract += 3.0))));
                double dlon = Math.max(180.0 - subtract, 0.0);
                double latLimit = this.findLatLimit(dlon) + (this.tilt_ > 0.0 ? 0.01 : -0.01);
                Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + dlon - 0.01, latLimit);
                if (dot == null || dot.x > lastDot.x) continue;
                vector3.add(new Point2D.Double(dot.x, dot.y));
                vector4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            }
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, vector1), new Bezier(false, vector2), new Bezier(false, vector3), new Bezier(false, vector4)};
        return curves;
    }

    protected Bezier[] makeBorders0() {
        double edgeLon = this.lambdaC_ + 180.0 - 0.05;
        int numPt = 30;
        double fact = 3.0;
        Point2D.Double[] dotsE = new Point2D.Double[61];
        Point2D.Double[] dotsW = new Point2D.Double[61];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[30 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[30 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[30 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[30 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        Bezier[] curves = new Bezier[5];
        curves[0] = new Bezier(false, dotsE);
        curves[1] = new Bezier(false, dotsW);
        return curves;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambda = this.lon2Lambda(lon);
        double latLimit = this.findLatLimit(lambda);
        if (this.tilt_ > 0.0 && lat < latLimit || this.tilt_ < 0.0 && lat > latLimit) {
            return null;
        }
        double phiRad = RaiszHalfEllipsoidal.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double halfLambdaRad = 0.5 * RaiszHalfEllipsoidal.toRadians(lambda);
        double x = 2.0 * Math.sin(halfLambdaRad) * cosPhi;
        double y = this.yShift_ + sinPhi * this.cosTilt_ - 2.0 * this.sinTilt_ * cosPhi * Math.cos(halfLambdaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (y < this.yMin_ || y > this.yMax_) {
            return null;
        }
        double xa = Math.abs(x);
        if (xa > (double)this.xMax_ || Math.abs(y) > this.yMax_) {
            return null;
        }
        double phiRad0 = (this.latMin_ + (y - this.yMin_) / (this.yMax_ - this.yMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
        double[] llRad = this.iterateRad(xa, y, 2.356194490192345, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambda = RaiszHalfEllipsoidal.toDegrees(llRad[0]);
        double phi = RaiszHalfEllipsoidal.toDegrees(llRad[1]);
        if (xa < 0.0) {
            lambda = -lambda;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        int iy = -((int)this.yMax_);
        while ((double)iy < this.yMax_) {
            double y = (double)iy + 0.5;
            if (!(y < this.yMin_) && !(y > this.yMax_)) {
                double x;
                double[] llRad;
                double lambdaRad = 1.0E-5;
                double phiRad = (this.latMin_ + (y - this.yMin_) / (this.yMax_ - this.yMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
                for (int ix = 0; ix < this.xMax_ && (llRad = this.iterateRad(x = (double)ix + 0.5, y, lambdaRad += 1.0E-5, phiRad += 1.0E-5)) != null; ++ix) {
                    lambdaRad = llRad[0];
                    phiRad = llRad[1];
                    this.setBiSymmetricPoints(ix, iy, RaiszHalfEllipsoidal.toDegrees(lambdaRad), RaiszHalfEllipsoidal.toDegrees(phiRad));
                }
            }
            ++iy;
        }
    }

    private double findLatLimit(double dlambda) {
        return RaiszHalfEllipsoidal.toDegrees(this.findLatLimitRad(dlambda));
    }

    private double findLatLimitRad(double dlambda) {
        double limitRad = -Math.atan(0.5 * Math.cos(0.5 * dlambda * (Math.PI / 180)) / this.tanTilt_);
        return limitRad;
    }

    private double[] iterateRad(double x, double y, double lambdaRad0, double phiRad0) {
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            double halfLambdaRad = 0.5 * lambdaRad;
            double cosHalfLambda = Math.cos(halfLambdaRad);
            double sinHalfLambda = Math.sin(halfLambdaRad);
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double f1 = 2.0 * sinHalfLambda * cosPhi - xOverRS;
            double f2 = this.yShift_ + sinPhi * this.cosTilt_ - 2.0 * this.sinTilt_ * cosHalfLambda * cosPhi - yOverRS;
            double df1dPhi = -2.0 * sinHalfLambda * sinPhi;
            double df1dLambda = cosHalfLambda * cosPhi;
            double df2dPhi = this.cosTilt_ * cosPhi + 2.0 * this.sinTilt_ * cosHalfLambda * sinPhi;
            double df2dLambda = this.sinTilt_ * sinHalfLambda * cosPhi;
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) break;
            ++iters;
        }
        if (iters >= 25) {
            return null;
        }
        if (lambdaRad > Math.PI || lambdaRad < 0.0) {
            return null;
        }
        double phi = RaiszHalfEllipsoidal.toDegrees(phiRad);
        double phiLim = this.findLatLimit(RaiszHalfEllipsoidal.toDegrees(lambdaRad));
        if (this.tilt_ > 0.0 && phi < phiLim || this.tilt_ < 0.0 && phi > phiLim) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

