/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class RaiszArmadillo
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Raisz Armadillo";
    public static final int PROPERTIES = 128;
    private static final double DEFAULT_TILT = 20.0;
    private static final double MAX_TILT = 90.0;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 1.2071067811865475;
    private double tilt_;
    private double cosTilt_;
    private double sinTilt_;
    private double tanTilt_;
    private double yShift_;
    private double latMin_;
    private double latMax_;
    private double ycentMin_;
    private double ycentMax_;
    private double yhornMin_;
    private double yhornMax_;
    private Bezier[] bordersCurves_;

    public RaiszArmadillo(int width, int height) {
        this(width, height, 0, 0);
    }

    public RaiszArmadillo(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public RaiszArmadillo(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 128, width, height, xmargin, ymargin, 2.0, 1.2071067811865475);
        this.addParameter(new DoubleParameter("Tilt Angle", "\u00b0", 20.0, -90.0, 90.0));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setTiltAngle(((DoubleParameter)p).getValue());
    }

    public void setTiltAngle(double tilt) {
        if (Math.abs(tilt) > 90.0) {
            throw new IllegalArgumentException("Specified tilt out of valid range");
        }
        this.tilt_ = tilt;
        double tiltRad = RaiszArmadillo.toRadians(this.tilt_);
        this.cosTilt_ = Math.cos(tiltRad);
        this.sinTilt_ = Math.sin(tiltRad);
        this.tanTilt_ = Math.tan(tiltRad);
        this.autoscale();
    }

    protected void prepareScaling() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            this.setSizeFactors(2.0, this.cosTilt_);
        } else {
            double y1 = this.tilt_ > 0.0 ? this.cosTilt_ : -this.cosTilt_;
            double y2 = (this.tilt_ > 0.0 ? -1.0 : 1.0) - this.sinTilt_;
            this.setSizeFactors(2.0, 0.5 * Math.abs(y1 - y2));
        }
    }

    protected void finishScaling() {
        this.yShift_ = Math.abs(this.tilt_) < 1.0E-5 ? 0.0 : (this.tilt_ > 0.0 ? 0.5 * (this.sinTilt_ - this.cosTilt_ + 1.0) : 0.5 * (this.sinTilt_ + this.cosTilt_ - 1.0));
        this.latMin_ = this.tilt_ > 0.0 ? -90.0 + this.tilt_ + 0.01 : -90.0;
        this.latMax_ = this.tilt_ < 0.0 ? 90.0 + this.tilt_ - 0.01 : 90.0;
        this.ycentMin_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMin_).y;
        this.ycentMax_ = this.transformLL2XYIgnoreMargins((double)this.lambdaC_, (double)this.latMax_).y;
        this.yhornMin_ = this.tilt_ > 0.0 ? this.ycentMax_ : this.transformLL2XYIgnoreMargins((double)(this.lambdaC_ + 180.0), (double)-90.0).y;
        this.yhornMax_ = this.tilt_ < 0.0 ? this.ycentMin_ : this.transformLL2XYIgnoreMargins((double)(this.lambdaC_ + 180.0), (double)90.0).y;
        this.ycentMin_ = -(this.ycentMin_ - (double)this.outCenterY_);
        this.ycentMax_ = -(this.ycentMax_ - (double)this.outCenterY_);
        this.yhornMin_ = -(this.yhornMin_ - (double)this.outCenterY_);
        this.yhornMax_ = -(this.yhornMax_ - (double)this.outCenterY_);
        this.bordersCurves_ = null;
    }

    protected void drawBorderLines(Graphics2D g2d) {
        if (this.bordersCurves_ == null) {
            this.bordersCurves_ = this.makeBorders();
        }
        for (Bezier curve : this.bordersCurves_) {
            if (curve == null) continue;
            curve.paint(g2d);
        }
        if (Math.abs(this.tilt_) < 1.0E-5) {
            Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + 180.0 - 0.05, 90.0);
            g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y));
        }
    }

    private Bezier[] makeBorders() {
        if (Math.abs(this.tilt_) < 1.0E-5) {
            return this.makeBorders0();
        }
        Vector<Point2D.Double> vector1 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector2 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector3 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector4 = new Vector<Point2D.Double>(100);
        int np = 60;
        double npfact = 3.0;
        double edgeLon = this.lambdaC_ + 180.0;
        Point2D.Double lastDot = null;
        for (int j = 0; j <= 60; ++j) {
            Point2D.Double dot;
            double lat = 90.0 - 3.0 * (double)j;
            if (this.tilt_ < 0.0) {
                lat *= -1.0;
            }
            if ((dot = this.transformLL2XY(edgeLon - 0.001, lat)) == null) break;
            vector1.add(new Point2D.Double(dot.x, dot.y));
            vector2.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
            lastDot = dot;
        }
        if (lastDot != null) {
            vector3.add(new Point2D.Double(lastDot.x, lastDot.y));
            vector4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - lastDot.x, lastDot.y));
        }
        double subtract = 0.0;
        while (subtract < 180.0) {
            subtract = subtract == 0.0 ? 0.001 : (Math.abs(this.tilt_) < 1.0 && subtract < 10.0 * Math.abs(this.tilt_) ? (subtract += 0.5 * Math.abs(this.tilt_)) : (subtract < 1.0 ? (subtract += 0.05) : (subtract < 5.0 ? (subtract += 0.4) : (subtract < 30.0 ? (subtract += 1.0) : (subtract < 60.0 ? (subtract += 2.0) : (subtract += 3.0))))));
            double dlon = Math.max(180.0 - subtract, 0.0);
            double latLimit = this.findLatLimit(dlon) + (this.tilt_ > 0.0 ? 0.01 : -0.01);
            Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + dlon - 0.01, latLimit);
            if (dot == null || dot.x > lastDot.x) continue;
            vector3.add(new Point2D.Double(dot.x, dot.y));
            vector4.add(new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        }
        int ew = 60;
        double ewfact = 3.0;
        double plat = this.tilt_ > 0.0 ? 89.9 : -89.9;
        Point2D.Double[] dots5 = new Point2D.Double[121];
        for (int i = 0; i <= 60; ++i) {
            double dlon = 3.0 * (double)i;
            if (i == 60) {
                dlon -= 0.1;
            }
            Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + dlon, plat);
            dots5[60 - i] = new Point2D.Double(dot.x, dot.y);
            dots5[60 + i] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, vector1), new Bezier(false, vector2), new Bezier(false, vector3), new Bezier(false, vector4), new Bezier(false, dots5)};
        return curves;
    }

    protected Bezier[] makeBorders0() {
        double edgeLon = this.lambdaC_ + 180.0 - 0.05;
        int np = 30;
        double fact = 3.0;
        Point2D.Double[] dotsE = new Point2D.Double[61];
        Point2D.Double[] dotsW = new Point2D.Double[61];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[30 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[30 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[30 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[30 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        Bezier[] curves = new Bezier[5];
        curves[0] = new Bezier(false, dotsE);
        curves[1] = new Bezier(false, dotsW);
        return curves;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambda = this.lon2Lambda(lon);
        double latLimit = this.findLatLimit(lambda);
        if (this.tilt_ > 0.0 && lat < latLimit || this.tilt_ < 0.0 && lat > latLimit) {
            return null;
        }
        double phiRad = RaiszArmadillo.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double onePlusCosPhi = 1.0 + Math.cos(phiRad);
        double halfLambdaRad = 0.5 * lambda * (Math.PI / 180);
        double x = onePlusCosPhi * Math.sin(halfLambdaRad);
        double y = this.yShift_ + this.cosTilt_ * sinPhi - this.sinTilt_ * onePlusCosPhi * Math.cos(halfLambdaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xa = Math.abs(x);
        if (xa > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double lambdaRad0 = 1.0E-5;
        double phiRad0 = 1.0E-5;
        if (y >= this.ycentMin_ && y <= this.ycentMax_) {
            lambdaRad0 = 2.356194490192345;
            phiRad0 = (this.latMin_ + (y - this.ycentMin_) / (this.ycentMax_ - this.ycentMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
        } else if (y > this.yhornMin_ && y < this.yhornMax_) {
            if (this.tilt_ > 0.0) {
                lambdaRad0 = 2.0 * Math.acos((this.yShift_ + this.cosTilt_ - y * this.oneOverRS_) / this.sinTilt_);
                phiRad0 = 1.5533430342749532;
            } else if (this.tilt_ < 0.0) {
                lambdaRad0 = 2.0 * Math.acos((this.yShift_ - this.cosTilt_ - y * this.oneOverRS_) / this.sinTilt_);
                phiRad0 = -1.5533430342749532;
            } else {
                lambdaRad0 = 2.356194490192345;
                phiRad0 = 0.0;
            }
            double xMin = (int)(0.5 + this.rS_ * Math.sin(0.5 * lambdaRad0));
            if (xa < xMin) {
                return null;
            }
        } else {
            return null;
        }
        double[] llRad = this.iterateRad(xa, y, lambdaRad0, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambda = RaiszArmadillo.toDegrees(llRad[0]);
        double phi = RaiszArmadillo.toDegrees(llRad[1]);
        if (xa < 0.0) {
            lambda = -lambda;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double x;
            double[] llRad;
            int xMin;
            double phiRad;
            double lambdaRad;
            double y = (double)iy + 0.5;
            if (y >= this.ycentMin_ && y <= this.ycentMax_) {
                lambdaRad = 1.0E-5;
                phiRad = (this.latMin_ + (y - this.ycentMin_) / (this.ycentMax_ - this.ycentMin_) * (this.latMax_ - this.latMin_)) * (Math.PI / 180);
                xMin = 0;
            } else {
                if (!(y > this.yhornMin_) || !(y < this.yhornMax_)) continue;
                if (this.tilt_ > 0.0) {
                    lambdaRad = 2.0 * Math.acos((this.yShift_ + this.cosTilt_ - y * this.oneOverRS_) / this.sinTilt_);
                    phiRad = 1.5533430342749532;
                } else if (this.tilt_ < 0.0) {
                    lambdaRad = 2.0 * Math.acos((this.yShift_ - this.cosTilt_ - y * this.oneOverRS_) / this.sinTilt_);
                    phiRad = -1.5533430342749532;
                } else {
                    lambdaRad = 0.0;
                    phiRad = 0.0;
                }
                xMin = (int)(0.5 + this.rS_ * Math.sin(0.5 * lambdaRad));
            }
            for (int ix = xMin; ix < this.xMax_ && (llRad = this.iterateRad(x = (double)ix + 0.5, y, lambdaRad += 1.0E-5, phiRad += 1.0E-5)) != null; ++ix) {
                lambdaRad = llRad[0];
                phiRad = llRad[1];
                this.setBiSymmetricPoints(ix, iy, RaiszArmadillo.toDegrees(lambdaRad), RaiszArmadillo.toDegrees(phiRad));
            }
        }
    }

    private double findLatLimit(double dlambda) {
        return RaiszArmadillo.toDegrees(this.findLatLimitRad(dlambda));
    }

    private double findLatLimitRad(double dlambda) {
        double limit = -Math.atan(Math.cos(0.5 * RaiszArmadillo.toRadians(dlambda)) / this.tanTilt_);
        return limit;
    }

    private double[] iterateRad(double x, double y, double lambdaRad0, double phiRad0) {
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            double halfLambdaRad = 0.5 * lambdaRad;
            double cosHalfLambda = Math.cos(halfLambdaRad);
            double sinHalfLambda = Math.sin(halfLambdaRad);
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double onePlusCosPhi = 1.0 + Math.cos(phiRad);
            double f1 = onePlusCosPhi * sinHalfLambda - xOverRS;
            double f2 = this.yShift_ + this.cosTilt_ * sinPhi - this.sinTilt_ * onePlusCosPhi * cosHalfLambda - yOverRS;
            double df1dPhi = -sinHalfLambda * sinPhi;
            double df1dLambda = 0.5 * onePlusCosPhi * cosHalfLambda;
            double df2dPhi = this.cosTilt_ * cosPhi + this.sinTilt_ * cosHalfLambda * sinPhi;
            double df2dLambda = 0.5 * this.sinTilt_ * onePlusCosPhi * sinHalfLambda;
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) break;
            ++iters;
        }
        if (iters >= 25) {
            return null;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = RaiszArmadillo.toDegrees(phiRad);
        double phiLim = this.findLatLimit(RaiszArmadillo.toDegrees(lambdaRad));
        if (this.tilt_ > 0.0 && phi < phiLim || this.tilt_ < 0.0 && phi > phiLim) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

