/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;

public abstract class QuadSymmetricProjection
extends AbstractProjection {
    public QuadSymmetricProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    protected void setQSymmetricPoints(int ix, int iy, double lambda, double phi) {
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - 1 - ix;
        int row = this.outCenterY_ - 1 - iy;
        int rowF = this.outCenterY_ + iy;
        if (row < 0 || row >= this.outHeight_ || rowF < 0 || rowF >= this.outHeight_ || col < 0 || col >= this.outWidth_ || colF < 0 || colF >= this.outWidth_) {
            return;
        }
        int indexTR = row * this.outWidth_ + col;
        int indexTL = row * this.outWidth_ + colF;
        int indexBR = rowF * this.outWidth_ + col;
        int indexBL = rowF * this.outWidth_ + colF;
        this.invArrayLon_[indexTR] = QuadSymmetricProjection.normalizeLon360(this.lambdaC_ + lambda);
        this.invArrayLon_[indexTL] = QuadSymmetricProjection.normalizeLon360(this.lambdaC_ - lambda);
        this.invArrayLon_[indexBR] = this.invArrayLon_[indexTR];
        this.invArrayLon_[indexBL] = this.invArrayLon_[indexTL];
        this.invArrayLat_[indexTR] = phi;
        this.invArrayLat_[indexTL] = phi;
        this.invArrayLat_[indexBR] = -phi;
        this.invArrayLat_[indexBL] = -phi;
        int srcY = this.getSrcPixelY(phi);
        int srcYF = this.getSrcPixelY(-phi);
        int srcX = this.getSrcPixelX(this.lambdaC_ + lambda);
        int srcXF = this.getSrcPixelX(this.lambdaC_ - lambda);
        if (srcY > -1) {
            if (srcX > -1) {
                this.invArray_[indexTR] = srcY * this.srcWidth_ + srcX;
            }
            if (srcXF > -1) {
                this.invArray_[indexTL] = srcY * this.srcWidth_ + srcXF;
            }
        }
        if (srcYF > -1) {
            if (srcX > -1) {
                this.invArray_[indexBR] = srcYF * this.srcWidth_ + srcX;
            }
            if (srcXF > -1) {
                this.invArray_[indexBL] = srcYF * this.srcWidth_ + srcXF;
            }
        }
    }
}

