/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP6P
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P6'";
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double TERMA = 0.886586;
    private static final double TERMB = 0.804044;
    private static final double TERMC = SQRT3 * 4.0 - Math.log(SQRT3 + 2.0);
    private static final double ONE_OVER_C = 1.0 / TERMC;
    private static final double WIDTH_FACTOR = 2.78529206437556;
    private static final double HEIGHT_FACTOR = 0.804044 * SQRT3;
    private double twoOverRSA_;
    private double oneOverRSB_;

    public PutninsP6P(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP6P(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP6P(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.78529206437556, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.twoOverRSA_ = 2.0 * this.oneOverRS_ / 0.886586;
        this.oneOverRSB_ = this.oneOverRS_ / 0.804044;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP6P.toRadians(lat);
        double cSinPhi = TERMC * Math.sin(phiRad);
        double alpha = SQRT3 * (lat / 90.0);
        double sqrtOnePlusAlpha2 = 0.0;
        for (int iter = 0; iter < 25; ++iter) {
            sqrtOnePlusAlpha2 = Math.sqrt(1.0 + alpha * alpha);
            double dalpha = -(alpha * (6.0 - sqrtOnePlusAlpha2) - Math.log(alpha + sqrtOnePlusAlpha2) - cSinPhi) / (6.0 - 2.0 * sqrtOnePlusAlpha2);
            alpha += dalpha;
            if (Math.abs(dalpha) < 1.0E-5) break;
        }
        double x = 0.443293 * this.lon2LambdaRad(lon) * (3.0 - sqrtOnePlusAlpha2);
        double y = 0.804044 * alpha;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double alpha = y * this.oneOverRSB_;
        double sqrtOnePlusAlpha2 = Math.sqrt(1.0 + alpha * alpha);
        double sinPhi = (alpha * (6.0 - sqrtOnePlusAlpha2) - Math.log(alpha + sqrtOnePlusAlpha2)) * ONE_OVER_C;
        double phiRad = Math.asin(sinPhi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.twoOverRSA_ / (3.0 - sqrtOnePlusAlpha2);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = PutninsP6P.toDegrees(phiRad);
        double lambda = PutninsP6P.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double sqrtOnePlusAlpha2;
        double y;
        double alpha;
        double sinPhi;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(sinPhi = ((alpha = (y = (double)iy + 0.5) * this.oneOverRSB_) * (6.0 - (sqrtOnePlusAlpha2 = Math.sqrt(1.0 + alpha * alpha))) - Math.log(alpha + sqrtOnePlusAlpha2)) * ONE_OVER_C)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = PutninsP6P.toDegrees(phiRad);
            double xFactor = this.twoOverRSA_ / (3.0 - sqrtOnePlusAlpha2);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, PutninsP6P.toDegrees(lambdaRad), phi);
            }
        }
    }
}

