/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP5p
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P5'";
    private static final double TERMA = 1.013456;
    private static final double TERMB = 1.2158542037080533;
    private static final double WIDTH_FACTOR = 3.183865924336497;
    private static final double HEIGHT_FACTOR = 1.5919329621682485;
    private double oneOverRSA_;

    public PutninsP5p(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP5p(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP5p(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 3.183865924336497, 1.5919329621682485);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.oneOverRSA_ = this.oneOverRS_ / 1.013456;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP5p.toRadians(lat);
        double x = 0.506728 * this.lon2LambdaRad(lon) * (3.0 - Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
        double y = 1.013456 * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRSA_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRSA_ * 2.0 / (3.0 - Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = PutninsP5p.toDegrees(phiRad);
        double lambda = PutninsP5p.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRSA_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = PutninsP5p.toDegrees(phiRad);
            double xFactor = this.oneOverRSA_ * 2.0 / (3.0 - Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, PutninsP5p.toDegrees(lambdaRad), phi);
            }
        }
    }
}

