/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP4p
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P4'";
    private static final double TERMA = 2.0 * Math.sqrt(0.1909859317102744);
    private static final double TERMB = 2.0 * Math.sqrt(3.7699111843077517);
    private static final double TERMC = 0.8838834764831844;
    private static final double ONE_OVER_C = 1.131370849898476;
    private static final double WIDTH_FACTOR = TERMA * Math.PI;
    private static final double HEIGHT_FACTOR = TERMB * Math.sin(Math.asin(0.8838834764831844) / 3.0);
    private double oneOverRSA_;
    private double oneOverRSB_;

    public PutninsP4p(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP4p(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP4p(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.oneOverRSA_ = this.oneOverRS_ / TERMA;
        this.oneOverRSB_ = this.oneOverRS_ / TERMB;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP4p.toRadians(lat);
        double psiRad = Math.asin(0.8838834764831844 * Math.sin(phiRad));
        double x = TERMA * this.lon2LambdaRad(lon) * Math.cos(psiRad) / Math.cos(psiRad / 3.0);
        double y = TERMB * Math.sin(psiRad / 3.0);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double psiRad = 3.0 * Math.asin(y * this.oneOverRSB_);
        double phiRad = Math.asin(Math.sin(psiRad) * 1.131370849898476);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRSA_ * (Math.cos(psiRad / 3.0) / Math.cos(psiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = PutninsP4p.toDegrees(phiRad);
        double lambda = PutninsP4p.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double psiRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(Math.sin(psiRad = 3.0 * Math.asin((y = (double)iy + 0.5) * this.oneOverRSB_)) * 1.131370849898476)) > 1.5707963267948966); ++iy) {
            double phi = PutninsP4p.toDegrees(phiRad);
            double xFactor = this.oneOverRSA_ * (Math.cos(psiRad / 3.0) / Math.cos(psiRad));
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, PutninsP4p.toDegrees(lambdaRad), phi);
            }
        }
    }
}

