/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP3
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P3";
    private static final double TERMA = Math.sqrt(0.954929658551372);
    private static final double TERMB = TERMA * 4.0 / (Math.PI * Math.PI);
    private static final double WIDTH_FACTOR = TERMA * Math.PI;
    private static final double HEIGHT_FACTOR = TERMA * 1.5707963267948966;
    private double oneOverRSA_;

    public PutninsP3(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.oneOverRSA_ = this.oneOverRS_ / TERMA;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP3.toRadians(lat);
        double x = this.lon2LambdaRad(lon) * (TERMA - TERMB * phiRad * phiRad);
        double y = TERMA * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRSA_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / (TERMA - TERMB * phiRad * phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = PutninsP3.toDegrees(phiRad);
        double lambda = PutninsP3.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRSA_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = PutninsP3.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / (TERMA - TERMB * phiRad * phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, PutninsP3.toDegrees(lambdaRad), phi);
            }
        }
    }
}

