/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP2
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P2";
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double TERMA = 0.947449;
    private static final double TERMB = 1.718482;
    private static final double TERMC = (Math.PI * 4 - 3.0 * SQRT3) / 6.0;
    private static final double ONE_OVER_C = 1.0 / TERMC;
    private static final double WIDTH_FACTOR = 2.9764988180509957;
    private static final double HEIGHT_FACTOR = 0.859241 * SQRT3;
    private double oneOverRSA_;
    private double oneOverRSB_;

    public PutninsP2(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.9764988180509957, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.oneOverRSA_ = this.oneOverRS_ / 0.947449;
        this.oneOverRSB_ = this.oneOverRS_ / 1.718482;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP2.toRadians(lat);
        double cSinPhi = TERMC * Math.sin(phiRad);
        double psiRad = 0.5 * phiRad;
        for (int iter = 0; iter < 25; ++iter) {
            double twoPsiRad = 2.0 * psiRad;
            double func = twoPsiRad + Math.sin(twoPsiRad) - 2.0 * Math.sin(psiRad) - cSinPhi;
            double dfunc = 2.0 * (1.0 + Math.cos(twoPsiRad) - Math.cos(psiRad));
            double dpsiRad = -func / dfunc;
            psiRad += dpsiRad;
            if (Math.abs(dpsiRad) < 1.0E-5) break;
        }
        double x = 0.947449 * this.lon2LambdaRad(lon) * (2.0 * Math.cos(psiRad) - 1.0);
        double y = 1.718482 * Math.sin(psiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double psiRad = Math.asin(y * this.oneOverRSB_);
        double sinPhi = (2.0 * psiRad + Math.sin(2.0 * psiRad) - 2.0 * Math.sin(psiRad)) * ONE_OVER_C;
        double phiRad = Math.asin(sinPhi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRSA_ / (2.0 * Math.cos(psiRad) - 1.0);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = PutninsP2.toDegrees(phiRad);
        double lambda = PutninsP2.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double psiRad;
        double sinPhi;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(sinPhi = (2.0 * (psiRad = Math.asin((y = (double)iy + 0.5) * this.oneOverRSB_)) + Math.sin(2.0 * psiRad) - 2.0 * Math.sin(psiRad)) * ONE_OVER_C)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = PutninsP2.toDegrees(phiRad);
            double xFactor = this.oneOverRSA_ / (2.0 * Math.cos(psiRad) - 1.0);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, PutninsP2.toDegrees(lambdaRad), phi);
            }
        }
    }
}

