/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public abstract class PseudocylindricProjection
extends QuadSymmetricProjection {
    private Bezier[] curves = new Bezier[2];
    public static final int PROPERTIES = 4;

    public PseudocylindricProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        this.makeOuterBezier();
        g2d.draw(this.curves[0].getPath());
        g2d.draw(this.curves[1].getPath());
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + 180.0, 90.0);
        if (Math.abs(dot.x - (double)this.outCenterX_) < 1.0E-5) {
            return;
        }
        g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y));
    }

    protected void makeOuterBezier() {
        double edgeLon = this.lambdaC_ + 180.0 - 0.05;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        this.curves[0] = new Bezier(false, dotsE);
        this.curves[1] = new Bezier(false, dotsW);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.lambdaC_ - 180.0 + 1.0E-5;
        double rlon = this.lambdaC_ + 180.0 - 1.0E-5;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        if (label == null) {
            GraphicUtilities.drawLine(g2d, (float)dot1.x, (float)dot1.y, (float)dot2.x, (float)dot1.y);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int a = fm.getAscent();
        float x = (float)(dot2.x - 3.0 - 2.0 - (double)w);
        GraphicUtilities.drawLine(g2d, (float)dot1.x, (float)dot1.y, x - 2.0f, (float)dot1.y);
        GraphicUtilities.drawString(g2d, label, x, (float)(dot1.y + 0.5 * (double)a));
        GraphicUtilities.drawLine(g2d, x + (float)w + 2.0f, (float)dot1.y, (float)dot2.x, (float)dot1.y);
    }
}

