/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.AbstractProjection;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public final class ProjectionUtils {
    private ProjectionUtils() {
    }

    public static void drawEllipse(Graphics2D g2d, int centerX, int centerY, double wRadius, double hRadius) {
        g2d.translate(centerX, centerY);
        g2d.draw(new Ellipse2D.Double(-wRadius, -hRadius, 2.0 * wRadius, 2.0 * hRadius));
        g2d.translate(-centerX, -centerY);
    }

    public static void drawCurveBorder(Graphics2D g2d, AbstractProjection proj, int centerX, int centerY) {
        Point2D.Double dot;
        double jj;
        int j;
        double lambdaC = proj.getCenter().getLon();
        double edgeLon = lambdaC + 180.0 - 0.05;
        int np1 = 40;
        int np2 = 60;
        int np = 100;
        double np1fact = 1.5;
        double np2fact = 0.5;
        Point2D.Double[] dots = new Point2D.Double[401];
        for (j = 0; j < 40; ++j) {
            jj = 1.5 * (double)j;
            dot = proj.transformLL2XY(edgeLon, jj);
            if (dot.x < (double)centerX) {
                dot.x += 2.0 * ((double)centerX - dot.x);
            }
            dots[j] = new Point2D.Double(dot.x, dot.y);
            dots[200 - j] = new Point2D.Double(2.0 * (double)centerX - dot.x, dot.y);
            dots[200 + j] = new Point2D.Double(2.0 * (double)centerX - dot.x, 2.0 * (double)centerY - dot.y);
            dots[400 - j] = new Point2D.Double(dot.x, 2.0 * (double)centerY - dot.y);
        }
        for (j = 0; j <= 60; ++j) {
            jj = 60.0 + 0.5 * (double)j;
            dot = proj.transformLL2XY(edgeLon, jj);
            if (dot.x < (double)centerX) {
                dot.x += 2.0 * ((double)centerX - dot.x);
            }
            dots[40 + j] = new Point2D.Double(dot.x, dot.y);
            dots[200 - (40 + j)] = new Point2D.Double(2.0 * (double)centerX - dot.x, dot.y);
            dots[200 + (40 + j)] = new Point2D.Double(2.0 * (double)centerX - dot.x, 2.0 * (double)centerY - dot.y);
            dots[400 - (40 + j)] = new Point2D.Double(dot.x, 2.0 * (double)centerY - dot.y);
        }
        new Bezier(true, dots).paint(g2d);
    }
}

