/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class PointPoleProjection
extends QuadSymmetricProjection {
    private Bezier[] curves = new Bezier[2];

    public PointPoleProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        this.makeOuterBezier();
        this.curves[0].paint(g2d);
        this.curves[1].paint(g2d);
    }

    protected void makeOuterBezier() {
        double edgeLon = this.lambdaC_ + 180.0 - 0.05;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        this.curves[0] = new Bezier(false, dotsE);
        this.curves[1] = new Bezier(false, dotsW);
    }
}

