/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Pavlov
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Pavlov";
    private static final double A0 = 1.0;
    private static final double A2 = -0.1531;
    private static final double A4 = -0.0267;
    private static final double A2_OVER_3 = -0.05103333333333334;
    private static final double A4_OVER_5 = -0.00534;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.32193508523994;

    public Pavlov(int width, int height) {
        this(width, height, 0, 0);
    }

    public Pavlov(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Pavlov(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, 1.32193508523994);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Pavlov.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = this.lon2LambdaRad(lon);
        double y = phiRad * (1.0 + phiRad2 * (-0.05103333333333334 + phiRad2 * -0.00534));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double dphiRad = -(phiRad * (1.0 + phiRad2 * (-0.05103333333333334 + phiRad2 * -0.00534)) - yOverRS) / (1.0 + phiRad2 * (-0.1531 + phiRad2 * -0.0267));
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Pavlov.toDegrees(phiRad);
        double lambda = Pavlov.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
            double x;
            double lambdaRad;
            double yOverRS = y * this.oneOverRS_;
            phiRad += 1.0E-5;
            for (int iter = 0; iter < 25; ++iter) {
                double phiRad2 = phiRad * phiRad;
                double dphiRad = -(phiRad * (1.0 + phiRad2 * (-0.05103333333333334 + phiRad2 * -0.00534)) - yOverRS) / (1.0 + phiRad2 * (-0.1531 + phiRad2 * -0.0267));
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = Pavlov.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Pavlov.toDegrees(lambdaRad), phi);
            }
        }
    }
}

