/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Parabolic
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Parabolic";
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double SQRT3PI = Math.sqrt(Math.PI * 3);
    private static final double SQRT3OVERPI = Math.sqrt(0.954929658551372);
    private static final double WIDTH_FACTOR = SQRT3PI;
    private static final double HEIGHT_FACTOR = 0.5 * SQRT3PI;

    public Parabolic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Parabolic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Parabolic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRadOver3 = Parabolic.toRadians(lat) / 3.0;
        double x = SQRT3OVERPI * this.lon2LambdaRad(lon) * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
        double y = SQRT3PI * Math.sin(phiRadOver3);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double rSSqrt3OverPi = this.rS_ * SQRT3OVERPI;
        double oneOverRSSqrt3Pi = 1.0 / (this.rS_ * SQRT3PI);
        double phiRad = 3.0 * Math.asin(y * oneOverRSSqrt3Pi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x / (rSSqrt3OverPi * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Parabolic.toDegrees(phiRad);
        double lambda = Parabolic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        double rSSqrt3OverPi = this.rS_ * SQRT3OVERPI;
        double oneOverRSSqrt3Pi = 1.0 / (this.rS_ * SQRT3PI);
        for (int iy = 0; iy < this.yMax_ && !((phi = Parabolic.toDegrees(phiRad = 3.0 * Math.asin((y = (double)iy + 0.5) * oneOverRSSqrt3Pi))) > 90.0); ++iy) {
            double xFactor = 1.0 / (rSSqrt3OverPi * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, Parabolic.toDegrees(lambdaRad), phi);
            }
        }
    }
}

