/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Orthographic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Orthographic";
    public static final int PROPERTIES = 131104;
    private static final double DEFAULT_RADIUS = 90.0;
    private double radiusDeg_;
    private double radiusRad_;

    public Orthographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public Orthographic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Orthographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131104, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new DoubleParameter("Radius", "\u00b0", 90.0, 1.0E-4, 90.0, true, true));
        this.parameterChanged(null);
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        }
        if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setRadius(((DoubleParameter)p).getValue());
    }

    public void setRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Orthographic.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    protected void prepareScaling() {
        double rhoMaxOverR = Math.sin(this.radiusRad_);
        this.setSizeFactors(rhoMaxOverR, rhoMaxOverR);
    }

    protected void finishScaling() {
        this.rhoBorder_ = this.rS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Orthographic.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ < 0.0) {
            return null;
        }
        double x = cosPhi * Math.sin(lambdaRad);
        double y = this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rS_ * this.rS_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double sinZ = rho * this.oneOverRS_;
        double cosZ = Math.sqrt(1.0 - sinZ * sinZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phi = Orthographic.toDegrees(phiRad);
        double lambda = Orthographic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double r2s2 = this.rS_ * this.rS_;
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > r2s2) continue;
                double rho = Math.sqrt(rho2);
                double sinZ = rho * this.oneOverRS_;
                double cosZ = Math.sqrt(1.0 - sinZ * sinZ);
                double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
                double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
                this.setBiSymmetricPoints(ix, iy, Orthographic.toDegrees(lambdaRad), Orthographic.toDegrees(phiRad));
            }
        }
    }
}

