/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class OrteliusOval
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Ortelius Oval";
    private static final double PI2_OVER_4 = 2.4674011002723395;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private BooleanParameter param0_ = new BooleanParameter("Global", true);
    private boolean global_ = true;

    public OrteliusOval(int width, int height) {
        this(width, height, 0, 0);
    }

    public OrteliusOval(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public OrteliusOval(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.param0_);
    }

    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setGlobal(this.param0_.isSelected());
    }

    public void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    protected void prepareScaling() {
        if (this.global_) {
            this.setSizeFactors(Math.PI, 1.5707963267948966);
        } else {
            this.setSizeFactors(1.5707963267948966, 1.5707963267948966);
        }
    }

    protected void drawBorderLines(Graphics2D g2d) {
        if (this.global_) {
            super.drawBorderLines(g2d);
            return;
        }
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.ymRS_, this.ymRS_);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double add = this.global_ ? 180.0 : 90.0;
        double llon = this.lambdaC_ - add + 1.0E-4;
        double rlon = this.lambdaC_ + add - 1.0E-4;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null && dot2 == null) {
            return;
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo((float)dot1.x, (float)dot1.y);
        path.lineTo((float)dot2.x, (float)dot2.y);
        g2d.draw(path);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (!this.global_) {
            double diff;
            for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
            }
            while (diff < 0.0) {
                diff += 360.0;
            }
            if (Math.abs(diff - 90.0) < 1.0E-5 || Math.abs(diff - 270.0) < 1.0E-5) {
                return;
            }
        }
        super.drawMeridian(g2d, lon, label);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = OrteliusOval.toRadians(lat);
        double lambdaRad = this.lon2LambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double x = 1.0;
        double y = phiRad;
        if (lambdaRad == 0.0) {
            x = 0.0;
        } else {
            if (!this.global_ && absLambdaRad > 1.5707963267948966) {
                return null;
            }
            double f = absLambdaRad <= 1.5707963267948966 ? 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad) : 1.5707963267948966;
            x = absLambdaRad - f + Math.sqrt(f * f - phiRad * phiRad);
            if (lambdaRad < 0.0) {
                x *= -1.0;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double rho2 = x * x + y * y;
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS_ * this.rS_;
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (y == 0.0) {
            lambdaRad = x * this.oneOverRS_;
        } else if (rho2 > rhoMax2) {
            lambdaRad = x * this.oneOverRS_ + 1.5707963267948966 - Math.sqrt(2.4674011002723395 - phiRad * phiRad);
        } else {
            double b = -(rho2 - r2s2 * 2.4674011002723395) / (x * this.rS_);
            double c = -2.4674011002723395;
            lambdaRad = 0.5 * (-b + Math.sqrt(b * b - -9.869604401089358));
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (!this.global_ && Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phi = OrteliusOval.toDegrees(phiRad);
        double lambda = OrteliusOval.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS_ * this.rS_;
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            double phiRad = y * this.oneOverRS_;
            if (phiRad > 1.5707963267948966) continue;
            double phi = OrteliusOval.toDegrees(phiRad);
            double phiRad2 = phiRad * phiRad;
            double xFactor = 1.5707963267948966 - Math.sqrt(2.4674011002723395 - phiRad2);
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad;
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (x == 0.0) {
                    lambdaRad = 0.0;
                } else if (y == 0.0) {
                    lambdaRad = x * this.oneOverRS_;
                } else if (rho2 > rhoMax2) {
                    lambdaRad = x * this.oneOverRS_ + xFactor;
                } else {
                    double b = -(rho2 - r2s2 * 2.4674011002723395) / (x * this.rS_);
                    double c = -2.4674011002723395;
                    lambdaRad = 0.5 * (-b + Math.sqrt(b * b - 4.0 * c));
                }
                if (lambdaRad > Math.PI) continue;
                if (!this.global_ && lambdaRad > 1.5707963267948966) continue block0;
                this.setQSymmetricPoints(ix, iy, OrteliusOval.toDegrees(lambdaRad), phi);
            }
        }
    }
}

