/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class NellHammer
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Nell-Hammer";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.1415926535897931;

    public NellHammer(int width, int height) {
        this(width, height, 0, 0);
    }

    public NellHammer(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public NellHammer(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.1415926535897931);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = NellHammer.toRadians(lat);
        double x = 0.5 * this.lon2LambdaRad(lon) * (1.0 + Math.cos(phiRad));
        double y = 2.0 * (phiRad - Math.tan(0.5 * phiRad));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOver2RS = y * 0.5 * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int i = 0; i < 25; ++i) {
            double halfPhiRad = 0.5 * phiRad;
            double cosHalfPhi = Math.cos(halfPhiRad);
            double dphiRad = (phiRad - Math.tan(halfPhiRad) - yOver2RS) / (1.0 - 0.5 / (cosHalfPhi * cosHalfPhi));
            phiRad -= dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = 2.0 * x * this.oneOverRS_ / (1.0 + Math.cos(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = NellHammer.toDegrees(phiRad);
        double lambda = NellHammer.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double twoOverRS = 2.0 * this.oneOverRS_;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOver2RS = y * 0.5 * this.oneOverRS_;
            for (int i = 0; i < 25; ++i) {
                double halfPhiRad = 0.5 * phiRad;
                double cosHalfPhi = Math.cos(halfPhiRad);
                double dphiRad = (phiRad - Math.tan(halfPhiRad) - yOver2RS) / (1.0 - 0.5 / (cosHalfPhi * cosHalfPhi));
                phiRad -= dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double xFactor = twoOverRS / (1.0 + Math.cos(phiRad));
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, NellHammer.toDegrees(lambdaRad), NellHammer.toDegrees(phiRad));
            }
        }
    }
}

