/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Nell
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Nell";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.1060601577034328;
    private boolean found;

    public Nell(int width, int height) {
        this(width, height, 0, 0);
    }

    public Nell(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Nell(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.1060601577034328);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Nell.toRadians(lat);
        double phiFactor = 2.0 * Math.sin(phiRad);
        double thetaRad = phiRad;
        for (int iter = 0; iter < 25; ++iter) {
            double func = thetaRad + Math.sin(thetaRad) - phiFactor;
            double dfunc = 1.0 + Math.cos(thetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = 0.5 * this.lon2LambdaRad(lon) * (1.0 + Math.cos(thetaRad));
        double y = thetaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double thetaRad = y * this.oneOverRS_;
        double lambdaRad = 2.0 * x * this.oneOverRS_ / (1.0 + Math.cos(thetaRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phiRad = Math.asin(0.5 * (thetaRad + Math.sin(thetaRad)));
        double phi = Nell.toDegrees(phiRad);
        double lambda = Nell.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double thetaRad;
        double twoOverRS = 2.0 * this.oneOverRS_;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(0.5 * ((thetaRad = (y = (double)iy + 0.5) * this.oneOverRS_) + Math.sin(thetaRad)))) > 1.5707963267948966); ++iy) {
            double xFactor = 2.0 * this.oneOverRS_ / (1.0 + Math.cos(thetaRad));
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, Nell.toDegrees(lambdaRad), Nell.toDegrees(phiRad));
            }
        }
    }
}

