/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Mollweide
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Mollweide";
    private static final double CSUBX = 0.9003163161571062;
    private static final double CSUBY = 1.4142135623730951;
    private static final double CSUBX_B = 1.0;
    private static final double CSUBY_B = 1.2732395447351628;
    private static final double ONE_OVER_PI = 0.3183098861837907;
    private static final double WIDTH_FACTOR = 2.8284271247461903;
    private static final double HEIGHT_FACTOR = 1.4142135623730951;
    private double cSubX_ = 0.9003163161571062;
    private double cSubY_ = 1.4142135623730951;
    private double xFactor0_;
    private BooleanParameter bparam_ = new BooleanParameter("Apply Bromley's scaling", false);

    public Mollweide(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mollweide(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Mollweide(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 524292, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
        this.addParameter(this.bparam_);
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        super.parameterChanged(e);
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null || p == this.bparam_) {
            this.setUseBromleyVariant(this.bparam_.isSelected());
        }
    }

    public void setUseBromleyVariant(boolean b) {
        if (b) {
            this.cSubX_ = 1.0;
            this.cSubY_ = 1.2732395447351628;
        } else {
            this.cSubX_ = 0.9003163161571062;
            this.cSubY_ = 1.4142135623730951;
        }
        this.autoscale();
    }

    protected void prepareScaling() {
        this.setSizeFactors(this.cSubX_ * Math.PI, this.cSubY_);
    }

    protected void finishScaling() {
        this.xFactor0_ = this.oneOverRS_ / this.cSubX_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - this.cSubY_ * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + this.cSubY_ * this.rS_);
        }
        double phiRad = Mollweide.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double piSinPhi = Math.PI * sinPhi;
        double thetaRad = Mollweide.toRadians(lat);
        for (int iter = 0; iter < 25; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = this.cSubY_ * Math.sin(thetaRad);
        if (!this.isShowingInterrupted()) {
            x = this.cSubX_ * this.lon2LambdaRad(lon) * Math.cos(thetaRad);
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = Mollweide.normalizeLon180(lon) - clon;
            if (Mollweide.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon) * this.cSubX_;
            x = this.cSubX_ * Math.cos(thetaRad);
            x = cx + Mollweide.toRadians(dlon) * x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.oneOverRS_ / this.cSubY_);
        double phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.oneOverRS_ / (this.cSubX_ * Math.cos(thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Mollweide.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double thetaRad = Math.asin(yOverRS / this.cSubY_);
            double phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
            if (phiRad < -1.5707963267948966) continue;
            if (phiRad > 1.5707963267948966) break;
            double phi = Mollweide.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / (this.cSubX_ * Math.cos(thetaRad));
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

