/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class ModifiedGall
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Modified Gall";
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double TERM2 = 1.7071067811865475;
    private static final double TERM3 = 0.585786437626905;
    private static final double WIDTH_FACTOR = 2.324778563656447;
    private static final double HEIGHT_FACTOR = 1.7071067811865475 * Math.tan(0.7853981633974483);
    private static final double ONE_OVER_SQRT2 = 0.7071067811865475;

    public ModifiedGall(int width, int height) {
        this(width, height, 0, 0);
    }

    public ModifiedGall(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ModifiedGall(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.324778563656447, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = ModifiedGall.toRadians(lat);
        double tanHalfPhi = Math.tan(0.5 * phiRad);
        double x = this.lon2LambdaRad(lon) * 0.7071067811865475 * (1.0 - 0.04 * phiRad * phiRad * phiRad * phiRad);
        double y = 1.7071067811865475 * tanHalfPhi;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.oneOverRS_ * 0.585786437626905);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ * 1.4142135623730951 / (1.0 - 0.04 * phiRad * phiRad * phiRad * phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = ModifiedGall.toDegrees(phiRad);
        double lambda = ModifiedGall.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.oneOverRS_ * 0.585786437626905)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = ModifiedGall.toDegrees(phiRad);
            double tanHalfPhi = Math.tan(0.5 * phiRad);
            double xFactor = this.oneOverRS_ * 1.4142135623730951 / (1.0 - 0.04 * phiRad * phiRad * phiRad * phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, ModifiedGall.toDegrees(lambdaRad), phi);
            }
        }
    }
}

