/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class MillerCylindric
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Miller Cylindric";
    public static final double TERMN = 1.25;
    public static final double TWO_M = 2.5;
    public static final double ONE_OVER_N = 0.8;
    public static final double ONE_OVER_2M = 0.4;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.25 * Math.log(Math.tan(1.413716694115407));
    private double oneOverRSN_;

    public MillerCylindric(int width, int height) {
        this(width, height, 0, 0);
    }

    public MillerCylindric(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MillerCylindric(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.oneOverRSN_ = this.oneOverRS_ * 0.8;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.lon2LambdaRad(lon);
        double y = 1.25 * Math.log(Math.tan(0.7853981633974483 + MillerCylindric.toRadians(lat) * 0.4));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 2.5 * (Math.atan(Math.exp(y * this.oneOverRSN_)) - 0.7853981633974483);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = MillerCylindric.toDegrees(phiRad);
        double lambda = MillerCylindric.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.5 * (Math.atan(Math.exp((y = (double)iy + 0.5) * this.oneOverRSN_)) - 0.7853981633974483)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = MillerCylindric.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, MillerCylindric.toDegrees(lambdaRad), phi);
            }
        }
    }
}

